#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct RaymarchParams
{
    vec3 function_scale;
    int show_bounding_box;
    vec3 function_origin;
    int clamp_to_volume;
    int use_instance_origin;
    int txt1_flip_y;
    int txt2_flip_y;
    int gradient_idx;
    vec4 near_far_plane;
    int trace_inside;
    int _pad0;
    int _pad1;
    int _pad2;
    vec4 camera_projection_params;
    vec2 frustum_shift;
    vec2 resolution;
    float animation_time;
    float prestep;
    float intersection_density_modifier;
    float density;
    float intensity;
    float opacity;
    float dithering;
    float sampling_mip;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _1865
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 1, binding = 4, std140) uniform RaymarchParamsBuffer
{
    RaymarchParams raymarch_params;
} _424;

layout(set = 1, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 5, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _949;

layout(set = 1, binding = 2, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 7, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1033;

layout(set = 1, binding = 8, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1657;

layout(set = 1, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1667;

layout(set = 1, binding = 9) uniform sampler2D s_Gradients;
layout(set = 1, binding = 10) uniform sampler3D s_voxel_colors_filtered;
layout(set = 1, binding = 11) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 1, binding = 12) uniform sampler2D s_NoiseRGBA;
layout(set = 1, binding = 13) uniform sampler2D sImage1;
layout(set = 1, binding = 14) uniform sampler2DShadow LightShadowmapCmpSamplers[16];
layout(set = 1, binding = 30) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 31) uniform sampler2D sDepth;

layout(location = 0) flat in uint instanceID;
layout(location = 1) in _1865 vtx_input;

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

float linearizeDepth(float d)
{
    return _424.raymarch_params.near_far_plane.z / ((_424.raymarch_params.near_far_plane.y + _424.raymarch_params.near_far_plane.x) - (d * _424.raymarch_params.near_far_plane.w));
}

float sdBox(vec3 p, vec3 b)
{
    vec3 q = abs(p) - b;
    return length(max(q, vec3(0.0))) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float raymarchBBox(vec3 ro, vec3 rd, vec3 function_scale)
{
    float h = 0.00200000009499490261077880859375;
    float t = 0.0;
    float res = -1.0;
    for (int i = 0; i < 48; i++)
    {
        if ((h < 0.001000000047497451305389404296875) || (t > 20000.0))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = vec3(1000.0);
        vec3 param_2 = ro + (rd * t);
        vec3 param_3 = (function_scale * 0.5) + vec3(0.00999999977648258209228515625);
        h = max(sdBox(param, param_1), -sdBox(param_2, param_3));
        t += h;
    }
    if (t < 20000.0)
    {
        res = t;
    }
    return res;
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_424.raymarch_params.frustum_shift * _424.raymarch_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_424.raymarch_params.camera_projection_params.z) + ((_424.raymarch_params.camera_projection_params.x * vd_pos.x) / _424.raymarch_params.resolution.x);
    view_direction.y = (-_424.raymarch_params.camera_projection_params.w) + ((_424.raymarch_params.camera_projection_params.y * vd_pos.y) / _424.raymarch_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _131 = v;
    float _135 = v.w;
    vec3 _138 = (_131.xyz * _135) * 128.0;
    v.x = _138.x;
    v.y = _138.y;
    v.z = _138.z;
    return v.xyz * v.xyz;
}

vec4 sample_voxelization_data(vec3 world_position, float color_lod, float occupancy_lod)
{
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (world_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _513 = source_voxel_position.x < 0.0;
    bool _520;
    if (!_513)
    {
        _520 = source_voxel_position.y < 0.0;
    }
    else
    {
        _520 = _513;
    }
    bool _527;
    if (!_520)
    {
        _527 = source_voxel_position.z < 0.0;
    }
    else
    {
        _527 = _520;
    }
    bool _534;
    if (!_527)
    {
        _534 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _534 = _527;
    }
    bool _541;
    if (!_534)
    {
        _541 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _541 = _534;
    }
    bool _548;
    if (!_541)
    {
        _548 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _548 = _541;
    }
    if (_548)
    {
        return vec4(0.0);
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, color_lod);
    vec3 _563 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _563;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, occupancy_lod).x;
    return vec4(voxel_color, voxel_occupancy);
}

float _noise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = (f * f) * (vec3(3.0) - (f * 2.0));
    vec2 uv = (p.xy + (vec2(37.0, 17.0) * p.z)) + f.xy;
    vec2 rg = textureLod(s_NoiseRGBA, (uv + vec2(0.5)) / vec2(256.0), 0.0).yx;
    return mix(rg.x, rg.y, f.z);
}

vec2 density_map(vec3 p, vec3 p_noise)
{
    float t = texture(sImage1, fract((p.xz / _424.raymarch_params.function_scale.xy) + vec2(0.5))).y;
    float b = 1.0 - clamp(abs(0.5 - t) * 2.0, 0.0, 1.0);
    vec3 param = vec3(p_noise * 3.1340999603271484375);
    float n = _noise(param);
    return vec2(t, (b * t) * clamp(n * 4.0, -0.5, 4.0));
}

vec4 map(vec3 p, vec3 world_p)
{
    vec3 param = world_p;
    float param_1 = _424.raymarch_params.sampling_mip;
    float param_2 = _424.raymarch_params.sampling_mip;
    vec4 voxel_color_occupancy = sample_voxelization_data(param, param_1, param_2);
    if (voxel_color_occupancy.w < 0.001000000047497451305389404296875)
    {
        return vec4(0.0);
    }
    float den = -2.0;
    float cloud_time = _424.raymarch_params.animation_time;
    vec3 q = ((p * 0.5) - (vec3(0.0, 0.0, 1.5) * cloud_time)) + ((vec3(-0.4000000059604644775390625, 0.0, 1.5) * cloud_time) * 0.703100025653839111328125);
    vec3 param_3 = p;
    vec3 param_4 = q;
    vec2 texture_base_den = density_map(param_3, param_4);
    vec3 param_5 = q * 13.3127002716064453125;
    float f = 0.25 * _noise(param_5);
    vec3 param_6 = q;
    f += (0.5 * _noise(param_6));
    q = (q * 2.019999980926513671875) - (vec3(0.0, 0.0, 1.39999997615814208984375) * cloud_time);
    vec3 param_7 = q;
    f += (0.25 * _noise(param_7));
    q = (q * 2.0299999713897705078125) - (vec3(0.0, 0.0, 1.60000002384185791015625) * cloud_time);
    vec3 param_8 = q;
    f += (0.125 * _noise(param_8));
    q = (q * 2.0099999904632568359375) - (vec3(0.0, 0.0, 1.7999999523162841796875) * cloud_time);
    vec3 param_9 = q;
    f += (0.0625 * _noise(param_9));
    q = (q * 2.019999980926513671875) - (vec3(0.0, 0.0, 1.0) * cloud_time);
    vec3 param_10 = q;
    f += (0.03125 * _noise(param_10));
    den += (4.0 * f);
    den = clamp(den, 0.0, 1.0);
    vec3 col = mix(vec3(1.0), vec3(0.60000002384185791015625, 0.5, 0.4000000059604644775390625), vec3(den * 0.5));
    vec4 color_density = vec4(col, ((den * 0.699999988079071044921875) * _424.raymarch_params.density) * 0.001000000047497451305389404296875);
    color_density.w *= voxel_color_occupancy.w;
    return color_density;
}

float testshadow(vec3 p, float dither)
{
    float shadow = 1.0;
    float s = 0.0500000007450580596923828125 * dither;
    for (int j = 0; j < 5; j++)
    {
        vec3 shadpos = p + (normalize(lights.light_properties[0].direction) * s);
        vec3 world_pos = shadpos;
        world_pos -= _424.raymarch_params.function_origin;
        world_pos /= _424.raymarch_params.function_scale;
        world_pos = (_949.transform_params.mModel * vec4(world_pos, 1.0)).xyz;
        vec3 param = shadpos;
        vec3 param_1 = world_pos;
        shadow -= (map(param, param_1).w * shadow);
        s += 0.07500000298023223876953125;
    }
    return shadow;
}

float sampleShadowPCF(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, int samples, float sampling_range)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _206 = coords.x < (-coords.w);
    bool _215;
    if (!_206)
    {
        _215 = coords.x > coords.w;
    }
    else
    {
        _215 = _206;
    }
    bool _225;
    if (!_215)
    {
        _225 = coords.y < (-coords.w);
    }
    else
    {
        _225 = _215;
    }
    bool _234;
    if (!_225)
    {
        _234 = coords.y > coords.w;
    }
    else
    {
        _234 = _225;
    }
    bool _241;
    if (!_234)
    {
        _241 = coords.z < 0.0;
    }
    else
    {
        _241 = _234;
    }
    if (_241)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _245 = coords;
    float _250 = coords.w;
    vec2 _252 = (_245.xy * vec2(0.5)) + (vec2(0.5) * _250);
    coords.x = _252.x;
    coords.y = _252.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    float sampling_r = 1.0;
    float _283 = -sampling_r;
    float y = _283;
    int iy = 0;
    for (; iy < samples; iy++, y += ((2.0 * sampling_r) / float(samples - 1)))
    {
        float _295 = -sampling_r;
        float x = _295;
        int ix = 0;
        for (; ix < samples; ix++, x += ((2.0 * sampling_r) / float(samples - 1)))
        {
            vec4 _321 = coords + vec4((x * sampling_range) * coords.w, (y * sampling_range) * coords.w, 0.0, 0.0);
            vec4 _324 = _321;
            _324.z = _321.w;
            float shadow = textureProjLod(smpl, vec4(_324.xy, _321.z, _324.z), 0.0);
            fact += shadow;
        }
    }
    float f = fact * (1.0 / float(samples * samples));
    return f;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float angle_falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    float attenuation = 0.0;
    bool _385 = angle_falloff > cutoff;
    bool _393;
    if (_385)
    {
        _393 = light_distance < light.range;
    }
    else
    {
        _393 = _385;
    }
    if (_393)
    {
        attenuation = 1.0 - ((1.0 - angle_falloff) / (1.0 - cutoff));
        attenuation = pow(attenuation, light.angular_falloff_power);
        float distance_attenuation = 1.0 - (light_distance / light.range);
        attenuation *= (distance_attenuation * distance_attenuation);
    }
    return attenuation;
}

float calculate_scene_light(vec3 world)
{
    float total_light = 0.0;
    int lights_num = 1;
    float param_1;
    for (int light_idx = 0; light_idx < lights_num; light_idx++)
    {
        LightProperties _994;
        _994.diffuse = lights.light_properties[light_idx].diffuse;
        _994.direction = lights.light_properties[light_idx].direction;
        _994.position = lights.light_properties[light_idx].position;
        _994.up = lights.light_properties[light_idx].up;
        _994.right = lights.light_properties[light_idx].right;
        _994.dimensions = lights.light_properties[light_idx].dimensions;
        _994.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
        _994.intensity = lights.light_properties[light_idx].intensity;
        _994.range = lights.light_properties[light_idx].range;
        _994.cutoff = lights.light_properties[light_idx].cutoff;
        _994.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
        _994.is_area = lights.light_properties[light_idx].is_area;
        _994.type = lights.light_properties[light_idx].type;
        _994.projector_sampler = lights.light_properties[light_idx].projector_sampler;
        _994.projector_intensity = lights.light_properties[light_idx].projector_intensity;
        _994.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
        _994.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
        _994.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
        _994.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
        _994.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
        _994.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
        _994.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
        _994.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
        _994.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
        _994.angular_falloff_power = lights.light_properties[light_idx].angular_falloff_power;
        _994.angular_falloff_color_gradient_idx = lights.light_properties[light_idx].angular_falloff_color_gradient_idx;
        _994.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
        _994.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
        _994.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
        _994.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
        _994.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
        _994.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
        _994.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
        _994.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
        _994.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
        LightProperties light = _994;
        float shadow = 0.0;
        bool calculate_shadows = (light.type & 8) != 0;
        if ((light.type & 3) != 0)
        {
            vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
            float in_frustum = 0.0;
            vec4 param = vShadowCoords;
            int param_2 = 1;
            float param_3 = materials.material_properties[_1033.materialIndex].shadowmap_bias;
            float _1047 = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param, param_1, param_2, param_3);
            in_frustum = param_1;
            shadow = _1047;
        }
        shadow = 1.0 - shadow;
        if ((light.type & 130) == 130)
        {
            LightProperties param_4 = light;
            vec3 param_5 = world;
            float attenuation_color = light_calculate_spot_attenuation(param_4, param_5);
            shadow *= length(attenuation_color);
        }
        total_light += (shadow * light.intensity);
    }
    return total_light / float(lights_num);
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec4 raymarch(vec3 ro, vec3 rd, float max_t, out float intersection)
{
    vec4 sum = vec4(0.0);
    float t = 0.0;
    intersection = -1.0;
    float t_step = 0.100000001490116119384765625;
    float dither = texelFetch(s_BlueNoise, ivec3(ivec2(uvec2(gl_FragCoord.xy) % uvec2(128u)), 0), 0).x;
    t += (_424.raymarch_params.dithering * dither);
    float total_scene_light = 0.0;
    float shadow = 0.0;
    for (int i = 0; i < 64; i++)
    {
        float trace_t = t + ((0.20000000298023223876953125 * t) * t);
        if (trace_t >= max_t)
        {
            break;
        }
        vec3 pos = ro + (rd * trace_t);
        vec3 world_pos = pos;
        world_pos -= _424.raymarch_params.function_origin;
        world_pos /= _424.raymarch_params.function_scale;
        vec3 param = world_pos;
        mat4 param_1 = _949.transform_params.mModel;
        vec3 _1164 = vector_transform_by_mat43(param, param_1);
        world_pos = _1164;
        vec3 param_2 = world_pos;
        float param_3 = _424.raymarch_params.sampling_mip;
        float param_4 = _424.raymarch_params.sampling_mip;
        vec4 voxel_color_occupancy = sample_voxelization_data(param_2, param_3, param_4);
        if (voxel_color_occupancy.w > 0.00999999977648258209228515625)
        {
            break;
        }
        t += (t_step * _424.raymarch_params.prestep);
    }
    for (int i_1 = 0; i_1 < 64; i_1++)
    {
        float trace_t_1 = t + ((0.20000000298023223876953125 * t) * t);
        if ((sum.w > 0.9900000095367431640625) || (trace_t_1 >= max_t))
        {
            break;
        }
        vec3 pos_1 = ro + (rd * trace_t_1);
        vec3 world_pos_1 = pos_1;
        world_pos_1 -= _424.raymarch_params.function_origin;
        world_pos_1 /= _424.raymarch_params.function_scale;
        vec3 param_5 = world_pos_1;
        mat4 param_6 = _949.transform_params.mModel;
        vec3 _1237 = vector_transform_by_mat43(param_5, param_6);
        world_pos_1 = _1237;
        vec3 param_7 = pos_1;
        vec3 param_8 = world_pos_1;
        vec4 col = map(param_7, param_8);
        vec3 param_9 = pos_1;
        float param_10 = dither;
        shadow = testshadow(param_9, param_10);
        float scene_light = 1.0;
        if (true)
        {
            vec3 world_pos_2 = pos_1;
            world_pos_2 -= _424.raymarch_params.function_origin;
            world_pos_2 /= _424.raymarch_params.function_scale;
            vec3 param_11 = world_pos_2 + vec3(dither * 0.0199999995529651641845703125);
            mat4 param_12 = _949.transform_params.mModel;
            vec3 _1273 = vector_transform_by_mat43(param_11, param_12);
            world_pos_2 = _1273;
            vec3 param_13 = world_pos_2;
            scene_light = calculate_scene_light(param_13) * 0.00999999977648258209228515625;
            total_scene_light += (scene_light * col.w);
        }
        vec3 cloud_color_for_shadow = vec3(1.0);
        if (_424.raymarch_params.gradient_idx != (-1))
        {
            int param_14 = _424.raymarch_params.gradient_idx;
            float param_15 = shadow;
            cloud_color_for_shadow = gradient_sample(param_14, param_15).xyz;
        }
        vec4 _1299 = col;
        vec3 _1301 = _1299.xyz * cloud_color_for_shadow;
        col.x = _1301.x;
        col.y = _1301.y;
        col.z = _1301.z;
        vec4 _1310 = col;
        vec3 _1312 = _1310.xyz * (scene_light + 0.100000001490116119384765625);
        col.x = _1312.x;
        col.y = _1312.y;
        col.z = _1312.z;
        float _1320 = col.w;
        vec4 _1321 = col;
        vec3 _1323 = _1321.xyz * _1320;
        col.x = _1323.x;
        col.y = _1323.y;
        col.z = _1323.z;
        float _1333 = sum.w;
        vec4 _1336 = sum;
        vec3 _1338 = _1336.xyz + (col.xyz * (1.0 - _1333));
        sum.x = _1338.x;
        sum.y = _1338.y;
        sum.z = _1338.z;
        sum.w = min(sum.w + col.w, 1.0);
        t += t_step;
    }
    vec4 bg = mix(vec4(0.300000011920928955078125, 0.4000000059604644775390625, 0.5, 0.0), vec4(0.5, 0.699999988079071044921875, 1.0, 0.0), vec4(smoothstep(-0.4000000059604644775390625, 0.0, rd.y)));
    float _1369 = sum.w;
    vec4 _1375 = sum;
    vec3 _1377 = _1375.xyz + ((bg.xyz * (1.0 - _1369)) * (total_scene_light * 0.0500000007450580596923828125));
    sum.x = _1377.x;
    sum.y = _1377.y;
    sum.z = _1377.z;
    intersection = t + ((0.20000000298023223876953125 * t) * t);
    return vec4(max(vec3(0.0), sum.xyz), sum.w);
}

float calcIntersection(vec3 ro, vec3 rd, float max_t, out vec4 color)
{
    vec3 param = ro;
    vec3 param_1 = rd;
    float param_2 = max_t;
    float param_3;
    vec4 _1410 = raymarch(param, param_1, param_2, param_3);
    float intersection = param_3;
    color = _1410;
    return intersection;
}

void main()
{
    MaterialPropertiesGPU _1642;
    _1642.diffuse = materials.material_properties[_1033.materialIndex].diffuse;
    _1642.transparency = materials.material_properties[_1033.materialIndex].transparency;
    _1642.emissive = materials.material_properties[_1033.materialIndex].emissive;
    _1642.roughness = materials.material_properties[_1033.materialIndex].roughness;
    _1642.triplanar_factor = materials.material_properties[_1033.materialIndex].triplanar_factor;
    _1642.refraction = materials.material_properties[_1033.materialIndex].refraction;
    _1642.normal_factor = materials.material_properties[_1033.materialIndex].normal_factor;
    _1642.emissive_factor = materials.material_properties[_1033.materialIndex].emissive_factor;
    _1642.temporal_accumulation_factor = materials.material_properties[_1033.materialIndex].temporal_accumulation_factor;
    _1642.shadowmap_bias = materials.material_properties[_1033.materialIndex].shadowmap_bias;
    _1642.metalness = materials.material_properties[_1033.materialIndex].metalness;
    _1642.albedo_sampler = materials.material_properties[_1033.materialIndex].albedo_sampler;
    _1642.emissive_sampler = materials.material_properties[_1033.materialIndex].emissive_sampler;
    _1642.normal_sampler = materials.material_properties[_1033.materialIndex].normal_sampler;
    _1642.metalic_roughness_sampler = materials.material_properties[_1033.materialIndex].metalic_roughness_sampler;
    _1642.flags = materials.material_properties[_1033.materialIndex].flags;
    _1642._pad0 = materials.material_properties[_1033.materialIndex]._pad0;
    _1642._pad1 = materials.material_properties[_1033.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1642;
    vec4 outAlbedo = vec4(1.0);
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (_1657.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1667.instance_transform[(instanceID * uint(_1657.instance_params.stride)) + 0u];
        vec4 inst_m1 = _1667.instance_transform[(instanceID * uint(_1657.instance_params.stride)) + 1u];
        vec4 inst_m2 = _1667.instance_transform[(instanceID * uint(_1657.instance_params.stride)) + 2u];
        vec3 _1702 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1702.x;
        mat_instance_model[0].y = _1702.y;
        mat_instance_model[0].z = _1702.z;
        vec3 _1715 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1715.x;
        mat_instance_model[1].y = _1715.y;
        mat_instance_model[1].z = _1715.z;
        vec3 _1728 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1728.x;
        mat_instance_model[2].y = _1728.y;
        mat_instance_model[2].z = _1728.z;
        vec3 _1741 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1741.x;
        mat_instance_model[3].y = _1741.y;
        mat_instance_model[3].z = _1741.z;
    }
    vec3 instance_function_origin = _424.raymarch_params.function_origin;
    if (_424.raymarch_params.use_instance_origin != 0)
    {
        instance_function_origin = (mat_instance_model * vec4(_424.raymarch_params.function_origin, 1.0)).xyz * 0.001000000047497451305389404296875;
    }
    mat_instance_model = _949.transform_params.mModel * mat_instance_model;
    mat4 mat_instance_model_inv = mat_instance_model;
    mat3 param = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
    mat3 inv = inverse_mat3(param);
    mat_instance_model_inv[0].x = inv[0].x;
    mat_instance_model_inv[0].y = inv[0].y;
    mat_instance_model_inv[0].z = inv[0].z;
    mat_instance_model_inv[1].x = inv[1].x;
    mat_instance_model_inv[1].y = inv[1].y;
    mat_instance_model_inv[1].z = inv[1].z;
    mat_instance_model_inv[2].x = inv[2].x;
    mat_instance_model_inv[2].y = inv[2].y;
    mat_instance_model_inv[2].z = inv[2].z;
    mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
    mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
    mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 ro = (mat_instance_model_inv * vec4(vtx_input.vCameraRelativeWorldPos + _949.transform_params.vCameraPosition, 1.0)).xyz;
    vec3 rd = (mat_instance_model_inv * vec4(_949.transform_params.vCameraPosition, 1.0)).xyz;
    rd = normalize(ro - rd);
    if (_424.raymarch_params.trace_inside != 0)
    {
        ro = (mat_instance_model_inv * vec4(_949.transform_params.vCameraPosition, 1.0)).xyz;
    }
    ro *= _424.raymarch_params.function_scale;
    vec3 ro_bounding_volume = ro;
    ro += instance_function_origin;
    float raw_depth = texelFetch(sDepth, ivec2(gl_FragCoord.xy), 0).x;
    float param_1 = raw_depth;
    float max_depth = linearizeDepth(param_1);
    vec4 color = vec4(1.0);
    float bounding_volume_intersection = 100000.0;
    if (_424.raymarch_params.clamp_to_volume != 0)
    {
        vec3 param_2 = ro_bounding_volume;
        vec3 param_3 = rd;
        vec3 param_4 = _424.raymarch_params.function_scale;
        bounding_volume_intersection = raymarchBBox(param_2, param_3, param_4);
    }
    bounding_volume_intersection = max_depth;
    vec2 param_5 = vec2(gl_FragCoord.xy);
    vec3 view_direction = get_view_direction(param_5);
    vec3 world = (_949.transform_params.mViewInv * vec4(view_direction * max_depth, 1.0)).xyz;
    float d = length((_949.transform_params.mModelInv * vec4(world - _949.transform_params.vCameraPosition, 0.0)).xyz);
    bounding_volume_intersection = d * _424.raymarch_params.function_scale.z;
    vec3 param_6 = ro;
    vec3 param_7 = rd;
    float param_8 = bounding_volume_intersection;
    vec4 param_9;
    float _2001 = calcIntersection(param_6, param_7, param_8, param_9);
    color = param_9;
    float intersection = _2001;
    if (intersection > 0.0)
    {
        vec3 ri = ro + (rd * intersection);
        ri -= instance_function_origin;
        ri /= _424.raymarch_params.function_scale;
        ri = ((_949.transform_params.mView * mat_instance_model) * vec4(ri, 1.0)).xyz;
        vec3 _2040 = (color.xyz * vec3(0.0, 50.0, 30.0)) * _424.raymarch_params.intensity;
        outAlbedo.x = _2040.x;
        outAlbedo.y = _2040.y;
        outAlbedo.z = _2040.z;
        outAlbedo.w = clamp(1.0 - (1.0 - (exp(-color.w) * _424.raymarch_params.opacity)), 0.0, 1.0);
        vec2 param_10 = vec2(gl_FragCoord.xy);
        vec3 view_direction_1 = get_view_direction(param_10);
        vec3 world_1 = (_949.transform_params.mViewInv * vec4(view_direction_1 * max_depth, 1.0)).xyz;
        float d_1 = length(_949.transform_params.vCameraPosition - world_1);
    }
    else
    {
        if (_424.raymarch_params.show_bounding_box != 0)
        {
            if (intersection == (-1.0))
            {
                outAlbedo = vec4(0.4000000059604644775390625, 0.20000000298023223876953125, 0.0, 1.0);
            }
            else
            {
                outAlbedo = vec4(5.0, 0.0, 0.0, 1.0);
            }
            vec3 _2102 = fract(vtx_input.vCoords * 0.00999999977648258209228515625);
            outAlbedo.x = _2102.x;
            outAlbedo.y = _2102.y;
            outAlbedo.z = _2102.z;
        }
        else
        {
            outAlbedo.w = 1.0;
            discard;
        }
    }
}

 