// (c) MX^Add
#pragma once

#ifndef PI_PICO_TARGET
#define _CRT_SECURE_NO_WARNINGS
#endif

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef PI_PICO_TARGET
#include <climits>
#include <cstring>
#endif
#include <math.h>
#include <stddef.h>
#include <string.h>
#include <assert.h>

#ifdef PI_PICO_TARGET
#undef MIN
#undef MAX
#else
#define __restrict 
#endif

#define TODO() assert(false)

typedef signed char sint8;
typedef unsigned char uint8;

typedef signed short sint16;
typedef unsigned short uint16;

typedef signed int sint32;
typedef unsigned int uint32;

#ifdef PI_PICO_TARGET
typedef int64_t sint64;
typedef uint64_t uint64;
#else
typedef signed __int64 sint64;
typedef unsigned __int64 uint64;
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////

template < class T >
constexpr inline T ABS(const T& V1)
{
	return (T)((V1<(T)0)?-V1:V1);
}

template < class T >
constexpr inline T SGN(const T& V1)
{
	if (V1 == 0) return (T) 0;
	if (V1 >  0) return (T) 1;
	return (T)-1;
}

template < class T >
constexpr inline T MIN(const T& V1, const T& V2)
{
	return V1 < V2 ? V1 : V2;
}

template < class T >
constexpr inline T MIN(const T& V1, const T& V2, const T& V3)
{
	return MIN(V1 < V2 ? V1 : V2, V3);
}

template < class T >
constexpr inline T MIN(const T& V1, const T& V2, const T& V3, const T& V4)
{
	return MIN(MIN(V1, V2),MIN(V3, V4));
}

template < class T >
constexpr inline T MAX(const T& V1, const T& V2)
{
	return V1 < V2 ? V2 : V1;
}

template < class T >
constexpr inline T MAX(const T& V1, const T& V2, const T& V3)
{
	return MAX(V1 < V2 ? V2 : V1, V3);
}

template < class T >
constexpr inline T MAX(const T& V1, const T& V2, const T& V3, const T& V4)
{
	return MAX(MAX(V1, V2), MAX(V3, V4));
}

template < class T >
constexpr inline T CLAMP(const T& V, const T& VMIN, const T& VMAX)
{
	return MIN(MAX(V, VMIN), VMAX);
}

template < class T >
constexpr inline T SQR(const T& V1)
{
	return V1*V1;
}

template < class T >
inline void SWAP(T& a, T& b)
{
	T t = a;
	  a = b;
	  b = t;
	return;
}
