// (c) MX^Add

#include "BaseTypes/ScalarType.h"

//
// Scalar implementation that uses float
//
const Scalar FScalar::SinTable [256+1] = { 0.000000f, 0.024541f, 0.049068f, 0.073565f, 0.098017f, 0.122411f, 0.146730f, 0.170962f, 0.195090f, 0.219101f, 0.242980f, 0.266713f, 0.290285f, 0.313682f, 0.336890f, 0.359895f, 0.382683f, 0.405241f, 0.427555f, 0.449611f, 0.471397f, 0.492898f, 0.514103f, 0.534998f, 0.555570f, 0.575808f, 0.595699f, 0.615232f, 0.634393f, 0.653173f, 0.671559f, 0.689541f, 0.707107f, 0.724247f, 0.740951f, 0.757209f, 0.773010f, 0.788346f, 0.803208f, 0.817585f, 0.831470f, 0.844854f, 0.857729f, 0.870087f, 0.881921f, 0.893224f, 0.903989f, 0.914210f, 0.923880f, 0.932993f, 0.941544f, 0.949528f, 0.956940f, 0.963776f, 0.970031f, 0.975702f, 0.980785f, 0.985278f, 0.989177f, 0.992480f, 0.995185f, 0.997290f, 0.998795f, 0.999699f, 1.000000f, 0.999699f, 0.998795f, 0.997290f, 0.995185f, 0.992480f, 0.989177f, 0.985278f, 0.980785f, 0.975702f, 0.970031f, 0.963776f, 0.956940f, 0.949528f, 0.941544f, 0.932993f, 0.923880f, 0.914210f, 0.903989f, 0.893224f, 0.881921f, 0.870087f, 0.857729f, 0.844854f, 0.831470f, 0.817585f, 0.803208f, 0.788346f, 0.773010f, 0.757209f, 0.740951f, 0.724247f, 0.707107f, 0.689541f, 0.671559f, 0.653173f, 0.634393f, 0.615232f, 0.595699f, 0.575808f, 0.555570f, 0.534997f, 0.514103f, 0.492898f, 0.471397f, 0.449611f, 0.427555f, 0.405241f, 0.382683f, 0.359895f, 0.336890f, 0.313682f, 0.290285f, 0.266713f, 0.242980f, 0.219101f, 0.195090f, 0.170962f, 0.146730f, 0.122411f, 0.098017f, 0.073564f, 0.049067f, 0.024541f, -0.000000f, -0.024541f, -0.049068f, -0.073565f, -0.098017f, -0.122411f, -0.146730f, -0.170962f, -0.195090f, -0.219101f, -0.242980f, -0.266713f, -0.290285f, -0.313682f, -0.336890f, -0.359895f, -0.382683f, -0.405241f, -0.427555f, -0.449612f, -0.471397f, -0.492898f, -0.514103f, -0.534998f, -0.555570f, -0.575808f, -0.595699f, -0.615232f, -0.634393f, -0.653173f, -0.671559f, -0.689541f, -0.707107f, -0.724247f, -0.740951f, -0.757209f, -0.773010f, -0.788346f, -0.803208f, -0.817585f, -0.831470f, -0.844854f, -0.857729f, -0.870087f, -0.881921f, -0.893224f, -0.903989f, -0.914210f, -0.923880f, -0.932993f, -0.941544f, -0.949528f, -0.956940f, -0.963776f, -0.970031f, -0.975702f, -0.980785f, -0.985278f, -0.989177f, -0.992480f, -0.995185f, -0.997290f, -0.998795f, -0.999699f, -1.000000f, -0.999699f, -0.998795f, -0.997290f, -0.995185f, -0.992480f, -0.989177f, -0.985278f, -0.980785f, -0.975702f, -0.970031f, -0.963776f, -0.956940f, -0.949528f, -0.941544f, -0.932993f, -0.923879f, -0.914210f, -0.903989f, -0.893224f, -0.881921f, -0.870087f, -0.857729f, -0.844853f, -0.831469f, -0.817585f, -0.803208f, -0.788346f, -0.773010f, -0.757209f, -0.740951f, -0.724247f, -0.707107f, -0.689541f, -0.671559f, -0.653173f, -0.634393f, -0.615231f, -0.595699f, -0.575808f, -0.555570f, -0.534998f, -0.514103f, -0.492898f, -0.471397f, -0.449611f, -0.427555f, -0.405241f, -0.382683f, -0.359895f, -0.336890f, -0.313682f, -0.290284f, -0.266712f, -0.242980f, -0.219101f, -0.195090f, -0.170962f, -0.146730f, -0.122410f, -0.098017f, -0.073565f, -0.049068f, -0.024541f, 0.000000f };
const Scalar FScalar::CosTable [256+1] = { 1.000000f, 0.999699f, 0.998795f, 0.997290f, 0.995185f, 0.992480f, 0.989177f, 0.985278f, 0.980785f, 0.975702f, 0.970031f, 0.963776f, 0.956940f, 0.949528f, 0.941544f, 0.932993f, 0.923880f, 0.914210f, 0.903989f, 0.893224f, 0.881921f, 0.870087f, 0.857729f, 0.844854f, 0.831470f, 0.817585f, 0.803208f, 0.788346f, 0.773010f, 0.757209f, 0.740951f, 0.724247f, 0.707107f, 0.689541f, 0.671559f, 0.653173f, 0.634393f, 0.615232f, 0.595699f, 0.575808f, 0.555570f, 0.534998f, 0.514103f, 0.492898f, 0.471397f, 0.449611f, 0.427555f, 0.405241f, 0.382683f, 0.359895f, 0.336890f, 0.313682f, 0.290285f, 0.266713f, 0.242980f, 0.219101f, 0.195090f, 0.170962f, 0.146730f, 0.122411f, 0.098017f, 0.073564f, 0.049068f, 0.024541f, -0.000000f, -0.024541f, -0.049068f, -0.073565f, -0.098017f, -0.122411f, -0.146731f, -0.170962f, -0.195090f, -0.219101f, -0.242980f, -0.266713f, -0.290285f, -0.313682f, -0.336890f, -0.359895f, -0.382684f, -0.405241f, -0.427555f, -0.449611f, -0.471397f, -0.492898f, -0.514103f, -0.534998f, -0.555570f, -0.575808f, -0.595699f, -0.615232f, -0.634393f, -0.653173f, -0.671559f, -0.689541f, -0.707107f, -0.724247f, -0.740951f, -0.757209f, -0.773010f, -0.788346f, -0.803208f, -0.817585f, -0.831470f, -0.844854f, -0.857729f, -0.870087f, -0.881921f, -0.893224f, -0.903989f, -0.914210f, -0.923880f, -0.932993f, -0.941544f, -0.949528f, -0.956940f, -0.963776f, -0.970031f, -0.975702f, -0.980785f, -0.985278f, -0.989177f, -0.992480f, -0.995185f, -0.997290f, -0.998795f, -0.999699f, -1.000000f, -0.999699f, -0.998795f, -0.997290f, -0.995185f, -0.992480f, -0.989177f, -0.985278f, -0.980785f, -0.975702f, -0.970031f, -0.963776f, -0.956940f, -0.949528f, -0.941544f, -0.932993f, -0.923880f, -0.914210f, -0.903989f, -0.893224f, -0.881921f, -0.870087f, -0.857729f, -0.844854f, -0.831470f, -0.817585f, -0.803208f, -0.788346f, -0.773010f, -0.757209f, -0.740951f, -0.724247f, -0.707107f, -0.689541f, -0.671559f, -0.653173f, -0.634393f, -0.615232f, -0.595699f, -0.575808f, -0.555570f, -0.534997f, -0.514103f, -0.492898f, -0.471397f, -0.449611f, -0.427555f, -0.405241f, -0.382683f, -0.359895f, -0.336890f, -0.313682f, -0.290285f, -0.266713f, -0.242980f, -0.219101f, -0.195090f, -0.170962f, -0.146730f, -0.122411f, -0.098017f, -0.073564f, -0.049067f, -0.024541f, 0.000000f, 0.024541f, 0.049068f, 0.073565f, 0.098017f, 0.122411f, 0.146730f, 0.170962f, 0.195090f, 0.219101f, 0.242980f, 0.266713f, 0.290285f, 0.313682f, 0.336890f, 0.359895f, 0.382684f, 0.405242f, 0.427555f, 0.449612f, 0.471397f, 0.492898f, 0.514103f, 0.534998f, 0.555570f, 0.575808f, 0.595699f, 0.615232f, 0.634393f, 0.653173f, 0.671559f, 0.689541f, 0.707107f, 0.724247f, 0.740951f, 0.757209f, 0.773011f, 0.788347f, 0.803208f, 0.817585f, 0.831470f, 0.844854f, 0.857729f, 0.870087f, 0.881921f, 0.893224f, 0.903989f, 0.914210f, 0.923880f, 0.932993f, 0.941544f, 0.949528f, 0.956940f, 0.963776f, 0.970031f, 0.975702f, 0.980785f, 0.985278f, 0.989177f, 0.992480f, 0.995185f, 0.997290f, 0.998795f, 0.999699f, 1.000000f };
const Scalar FScalar::ACosTable[256+1] = { 3.141593f, 3.016266f, 2.964237f, 2.924235f, 2.890443f, 2.860613f, 2.833591f, 2.808691f, 2.785468f, 2.763612f, 2.742898f, 2.723156f, 2.704255f, 2.686088f, 2.668572f, 2.651635f, 2.635221f, 2.619278f, 2.603765f, 2.588645f, 2.573888f, 2.559464f, 2.545349f, 2.531523f, 2.517964f, 2.504656f, 2.491584f, 2.478732f, 2.466089f, 2.453642f, 2.441381f, 2.429296f, 2.417377f, 2.405617f, 2.394008f, 2.382543f, 2.371214f, 2.360016f, 2.348943f, 2.337990f, 2.327151f, 2.316422f, 2.305798f, 2.295275f, 2.284849f, 2.274517f, 2.264274f, 2.254118f, 2.244045f, 2.234053f, 2.224138f, 2.214298f, 2.204529f, 2.194830f, 2.185199f, 2.175633f, 2.166129f, 2.156686f, 2.147302f, 2.137975f, 2.128703f, 2.119485f, 2.110318f, 2.101201f, 2.092132f, 2.083111f, 2.074135f, 2.065203f, 2.056314f, 2.047467f, 2.038660f, 2.029891f, 2.021161f, 2.012468f, 2.003809f, 1.995186f, 1.986596f, 1.978038f, 1.969512f, 1.961017f, 1.952551f, 1.944113f, 1.935704f, 1.927321f, 1.918965f, 1.910633f, 1.902326f, 1.894043f, 1.885783f, 1.877545f, 1.869328f, 1.861133f, 1.852957f, 1.844800f, 1.836663f, 1.828543f, 1.820440f, 1.812354f, 1.804285f, 1.796230f, 1.788191f, 1.780166f, 1.772154f, 1.764156f, 1.756170f, 1.748196f, 1.740233f, 1.732282f, 1.724340f, 1.716408f, 1.708486f, 1.700572f, 1.692666f, 1.684768f, 1.676877f, 1.668993f, 1.661115f, 1.653243f, 1.645375f, 1.637512f, 1.629654f, 1.621799f, 1.613947f, 1.606098f, 1.598251f, 1.590405f, 1.582561f, 1.574718f, 1.566875f, 1.559031f, 1.551187f, 1.543342f, 1.535495f, 1.527646f, 1.519794f, 1.511939f, 1.504080f, 1.496217f, 1.488350f, 1.480477f, 1.472599f, 1.464715f, 1.456824f, 1.448926f, 1.441020f, 1.433107f, 1.425184f, 1.417253f, 1.409311f, 1.401359f, 1.393397f, 1.385423f, 1.377437f, 1.369438f, 1.361427f, 1.353402f, 1.345362f, 1.337308f, 1.329238f, 1.321152f, 1.313050f, 1.304930f, 1.296792f, 1.288636f, 1.280460f, 1.272264f, 1.264048f, 1.255809f, 1.247549f, 1.239266f, 1.230959f, 1.222628f, 1.214272f, 1.205889f, 1.197479f, 1.189042f, 1.180576f, 1.172080f, 1.163554f, 1.154997f, 1.146407f, 1.137783f, 1.129125f, 1.120431f, 1.111701f, 1.102933f, 1.094126f, 1.085278f, 1.076389f, 1.067457f, 1.058482f, 1.049460f, 1.040392f, 1.031275f, 1.022108f, 1.012889f, 1.003617f, 0.994290f, 0.984906f, 0.975464f, 0.965960f, 0.956394f, 0.946762f, 0.937063f, 0.927295f, 0.917455f, 0.907540f, 0.897547f, 0.887474f, 0.877318f, 0.867076f, 0.856743f, 0.846318f, 0.835795f, 0.825171f, 0.814442f, 0.803603f, 0.792649f, 0.781577f, 0.770379f, 0.759050f, 0.747584f, 0.735975f, 0.724215f, 0.712297f, 0.700212f, 0.687950f, 0.675504f, 0.662860f, 0.650009f, 0.636936f, 0.623629f, 0.610070f, 0.596243f, 0.582129f, 0.567705f, 0.552947f, 0.537828f, 0.522315f, 0.506372f, 0.489957f, 0.473021f, 0.455504f, 0.437338f, 0.418436f, 0.398694f, 0.377981f, 0.356125f, 0.332902f, 0.308002f, 0.280979f, 0.251149f, 0.217358f, 0.177355f, 0.125327f, 0.000000f, 0.000000f };

Scalar FScalar::Sin(Scalar f)
{
	Scalar BDeg = f * FixedToBDeg;

	sint32 r    = sint32(BDeg);
	Scalar fr   = BDeg - r;
	uint8  a    = uint8(r);

	Scalar sa   = Scalar(SinTable[a+0]);
	Scalar sb   = Scalar(SinTable[a+1]);

	return sa + (sb-sa) * Scalar(fr);
}

Scalar FScalar::Cos(Scalar f)
{
	Scalar BDeg = f * FixedToBDeg;

	sint32 r    = sint32(BDeg);
	Scalar fr   = BDeg - r;
	uint8  a    = uint8(r);

	Scalar sa   = Scalar(CosTable[a+0]);
	Scalar sb   = Scalar(CosTable[a+1]);

	return sa + (sb-sa) * Scalar(fr);
}

Scalar FScalar::ACos(Scalar f)
{
	if (f <= -0.9999f)
		return FixedPi;

	if (f >= 0.9999f)
		return FixedZero;

	Scalar fa = (f * 0.5f + 0.5f) * 255.0f;
	sint32 r  = sint32(fa);
	uint8  a  = uint8(r);
	Scalar sa = Scalar(ACosTable[a+0]);
	Scalar sb = Scalar(ACosTable[a+1]);

	return sa + (sb-sa) * Scalar(fa-r);
}
