//
// ST7789 Display button helper
// Modified implementation, based on pico SDK
//

#pragma once

#include <stdint.h>
#include "hardware/gpio.h"
#include "pimoroni_common.hpp"

namespace pimoroni 
{
	class Button 
	{
	public:

		Button(uint _pin, Polarity _polarity = Polarity::ACTIVE_LOW, uint32_t _repeat_time = 200, uint32_t _hold_time = 1000) : pin(_pin), polarity(_polarity), repeat_time(_repeat_time), hold_time(_hold_time) 
		{
			gpio_set_function(pin, GPIO_FUNC_SIO);
			gpio_set_dir(pin, GPIO_IN);
			if (polarity == Polarity::ACTIVE_LOW) 
				gpio_pull_up(pin);
			else 
				gpio_pull_down(pin);
			return;
		}

		bool raw();
		bool read();

	private:
		uint pin;
		Polarity polarity;
		uint32_t repeat_time;
		uint32_t hold_time;
		bool pressed = false;
		bool last_state = false;
		uint32_t pressed_time = 0;
		uint32_t last_time = 0;
	};
}
