// (c) MX^Add
#pragma once

#define _CRT_SECURE_NO_WARNINGS

#include <fbxsdk.h>
#ifdef FBXSDK_ENV_WIN
#include <malloc.h>
#endif

#include <vector>
#include <string>
#include <utility>
#include <algorithm>
#include <cmath>

#include <DirectXMath.h>
#include <DirectXPackedVector.h>

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"

#ifndef FORCEINLINE
#define FORCEINLINE __forceinline
#endif

//
// POW2 check
//
static inline bool IsPowerOfTwo(unsigned int x)
{
	return (x != 0) && ((x & (x - 1)) == 0);
}

//
// Universal Lerp extension
//
namespace std
{
	template<class _Ty>
	constexpr const _Ty lerp(const _Ty& _Val_a, const _Ty& _Val_b, const _Ty& _Val_alpha)
	{	
		return _Val_a + (_Val_b - _Val_a) * _Val_alpha;
	}
}

//
// std::clamp is only in CXX17 - define it here ...
//
#if !_HAS_CXX17
namespace std
{
	template<class _Ty>
	constexpr const _Ty& clamp(const _Ty& _Val, const _Ty& _Min_val, const _Ty& _Max_val)
	{	
		return std::max(_Min_val, std::min(_Max_val, _Val));
	}
}
#endif // _HAS_CXX17

using namespace DirectX;	
using namespace DirectX::PackedVector;

#ifndef DEG2RAD
#define DEG2RAD(a)  (((a) * 3.14159265358979f) / 180.0f)
#endif

#ifndef RAD2DEG
#define RAD2DEG(a)  (((a)*360.0f) / (2.0f*3.14159265358979f)) 
#endif

FORCEINLINE float _EXTRACT_X(XMVECTOR a)
{
	return _mm_cvtss_f32(a);
}

FORCEINLINE float _EXTRACT_Y(XMVECTOR a)
{
	return a.m128_f32[1];
}

FORCEINLINE float _EXTRACT_Z(XMVECTOR a)
{
	return a.m128_f32[2];
}

FORCEINLINE float _EXTRACT_W(XMVECTOR a)
{
	return a.m128_f32[3];
}

FORCEINLINE uint32 _EXTRACT_XI(XMVECTOR a)
{
	return a.m128_u32[0];
}

FORCEINLINE uint32 _EXTRACT_YI(XMVECTOR a)
{
	return a.m128_u32[1];
}

FORCEINLINE uint32 _EXTRACT_ZI(XMVECTOR a)
{
	return a.m128_u32[2];
}

FORCEINLINE uint32 _EXTRACT_WI(XMVECTOR a)
{
	return a.m128_u32[3];
}

FORCEINLINE std::string MakeSafeName(const std::string &s)
{ 
	std::string r;

	for (char c : s) 
	{
		if (std::isalnum(static_cast<unsigned char>(c)) || c == '_') 
			r += c;
		else 
			r += '_';
	}

	return r;
}

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"
#include "RendererTypes/Gizmo.h"
#include "RendererTypes/Camera.h"
#include "RendererTypes/Mesh.h"
#include "RendererTypes/Scene.h"
