// (c) MX^Add

#include "SceneExporterCamera.h"
#include "SceneExporter.h"

FExporterCamera::FExporterCamera(FSceneExporter* Exporter, FExporterGizmo* ParentPtr, class FbxNode* Node) : FExporterGizmo(Exporter, ParentPtr, Node, true)
{
	Type = FGizmo::ENodeType::Camera;
	FOV  = 60.0f;
	Near = 1.0;
	Far  = 100.0f;

	Exporter->RegisterCamera(ID, Name);

	FbxCamera *Camera = Node->GetCamera();
	if (!Camera)
		return;

	Near = std::max(1.0f, float(Camera->GetNearPlane()));
	Far	 = std::clamp(float(Camera->GetFarPlane()), Near + 32.0f, 1024.0f);
	FOV	 = std::clamp(0.66f * float(Camera->ComputeFieldOfView(Camera->FocalLength.Get())), 1.0f, 180.0f); // NOTE::The 0.66f is almost half of the fov, adjusted for 320x200 aspect ratio.

	return;
}

FExporterCamera::~FExporterCamera()
{
	return;
}

size_t FExporterCamera::FillInternals(FSceneExporter *Exporter, FGizmo *Ptr)
{
	Super::FillInternals(Exporter, Ptr);

	FCamera *CPtr = (FCamera *)Ptr;

	CPtr->FOV  = uint8((FOV/180.0f)*128.0f);
	CPtr->Near = std::max(uint16(1), uint16(Near));
	CPtr->Far  = uint16(Far);

	return sizeof(FCamera);
}

void FExporterCamera::SavePayload(FSceneExporter* Exporter, FGizmo* Ptr)
{
	Super::SavePayload(Exporter, Ptr);
	return;
}