// (c) MX^Add
#pragma once

#include "Exporter.h"

class FSceneExporter;

static inline FMatrix ConvertFBXMatrix(const FbxMatrix &m)
{
	return FMatrix(Scalar((float)m.Get(0, 0)), Scalar((float)m.Get(0, 1)), Scalar((float)m.Get(0, 2)), Scalar((float)m.Get(0, 3)),
		Scalar((float)m.Get(1, 0)), Scalar((float)m.Get(1, 1)), Scalar((float)m.Get(1, 2)), Scalar((float)m.Get(1, 3)),
		Scalar((float)m.Get(2, 0)), Scalar((float)m.Get(2, 1)), Scalar((float)m.Get(2, 2)), Scalar((float)m.Get(2, 3)),
		Scalar((float)m.Get(3, 0)), Scalar((float)m.Get(3, 1)), Scalar((float)m.Get(3, 2)), Scalar((float)m.Get(3, 3)));
}

static inline XMFLOAT4X4 ConvertFBXMatrixXM(const FbxMatrix &m)
{
	XMMATRIX   Mat;
	XMFLOAT4X4 Res;
	Mat.r[0] = XMVectorSet((float)m.Get(0, 0), (float)m.Get(0, 1), (float)m.Get(0, 2), (float)m.Get(0, 3));
	Mat.r[1] = XMVectorSet((float)m.Get(1, 0), (float)m.Get(1, 1), (float)m.Get(1, 2), (float)m.Get(1, 3));
	Mat.r[2] = XMVectorSet((float)m.Get(2, 0), (float)m.Get(2, 1), (float)m.Get(2, 2), (float)m.Get(2, 3));
	Mat.r[3] = XMVectorSet((float)m.Get(3, 0), (float)m.Get(3, 1), (float)m.Get(3, 2), (float)m.Get(3, 3));
	XMStoreFloat4x4(&Res, Mat);
	return Res;
}

class FExporterGizmo
{
protected:
	friend class FSceneExporter;

	class FbxNode				 *Node;

	uint16						  ID;
	FGizmo::ENodeType			  Type;
	std::string					  Name;
	std::vector<XMFLOAT4X4>		  Locals;
	std::vector<FExporterGizmo *> Childs;
	FExporterGizmo			     *Parent;
	bool                          HaveAnyAnimation;


	FExporterGizmo(FSceneExporter *Exporter, FExporterGizmo *ParentPtr, class FbxNode *Node, bool Recurse);
	virtual ~FExporterGizmo();

	virtual size_t FillInternals(FSceneExporter *Exporter, FGizmo *Ptr);
	virtual void   SavePayload(FSceneExporter *Exporter, FGizmo *Ptr);

	void SaveData(FSceneExporter *Exporter);

	void Print(sint32 Tabs) const;

	uint32 GetSortKey() const;

	bool HaveAnimation() const
	{
		return HaveAnyAnimation;
	}

	void ReduceChilds(FExporterGizmo *Parent);

	void PostReduceCleanup();

	void SortChilds();

	void ReduceSelf(const XMFLOAT4X4 &Parent);

private:

	bool OptimizeLinear(std::vector<FCurveFixed::FKeys>& Keys, Scalar Epsilon, const char *CurveName) const;

	bool OptimizeQat(std::vector<FCurveQuat::FKeys>& Keys, Scalar Epsilon) const;

	bool Test(Scalar ConstTrnsX, const std::vector<FCurveFixed::FKeys> &TrnsX,
			  Scalar ConstTrnsY, const std::vector<FCurveFixed::FKeys> &TrnsY,
			  Scalar ConstTrnsZ, const std::vector<FCurveFixed::FKeys> &TrnsZ,
		  	  Scalar ConstScleX, const std::vector<FCurveFixed::FKeys> &ScleX,
		      Scalar ConstScleY, const std::vector<FCurveFixed::FKeys> &ScleY,
		      Scalar ConstScleZ, const std::vector<FCurveFixed::FKeys> &ScleZ,
			  const FVector4D &ConstRot, const std::vector<FCurveQuat::FKeys> &Rotation,
			  uint16 FrameStart, uint16 FrameEnd) const;
};