// (c) MX^Add
#pragma once

#include "Exporter.h"
#include "SceneExporterGizmo.h"

class FExporterMesh : public FExporterGizmo
{
	void ErrorClear();
	void OptimizeForVertexCache();
	void PreparePayload(FSceneExporter* Exporter, bool FromVisPass = false);
	void VisPass(FSceneExporter* Exporter);

protected:
	friend class FSceneExporter;
	friend class FExporterGizmo;
	typedef FExporterGizmo Super;

	struct FVertex
	{
		XMFLOAT3 Vtx;
		XMFLOAT3 Nrm;
		XMFLOAT4 Clr;
		XMFLOAT2 UV;

		FVertex()
		{
			memset(this, 0, sizeof(FVertex));
			return;
		}

		bool operator == (const FVertex &other) const 
		{ 
			if (!XMVector3NearEqual(XMLoadFloat3(&Vtx), XMLoadFloat3(&other.Vtx), XMVectorReplicate(0.001f)))
				return false;

			if (!XMVector3NearEqual(XMLoadFloat3(&Nrm), XMLoadFloat3(&other.Nrm), XMVectorReplicate(0.01f)))
				return false;

			if (!XMVector4NearEqual(XMLoadFloat4(&Clr), XMLoadFloat4(&other.Clr), XMVectorReplicate(1.0f / 32.0f)))
				return false;

			if (!XMVector2NearEqual(XMLoadFloat2(&UV), XMLoadFloat2(&other.UV), XMVectorReplicate(1.0f / 128.0f)))
				return false;

			return true;
		}
	};

	uint8				 MaterialID;
	std::string			 MaterialName;
	std::vector<FVertex> Vertices;
	std::vector<uint16>  Faces;
	std::vector<uint8>   PayloadVertexes;
	FMesh::EVertexFormat VertexFormat;
	uint16				 MaterialColor;
	FVector4D            BoundingSphere;

	FExporterMesh(FSceneExporter *Exporter, FExporterGizmo *ParentPtr, class FbxNode *Node, sint32 SectionID, bool Recurse);
	virtual ~FExporterMesh();

	void AddVertex(const FExporterMesh::FVertex &v);

	virtual size_t FillInternals(FSceneExporter *Exporter, FGizmo *Ptr) override;
	virtual void   SavePayload(FSceneExporter *Exporter, FGizmo *Ptr) override;
};
