// (c) MX^Add

#include "SceneVisibilityData.h"
#include "SceneExporter.h"

FSceneVisibilityInfo::FSceneVisibilityInfo(const char *Filename)
{
	if (!Filename || Filename[0] == 0)
		return;

	FILE *f = fopen(Filename, "rb");
	if (!f)
	{
		printf("\033[31mERROR::Failed to open visibility information file [%s] !\033[0m\n", Filename);	
		return;
	}

	uint32 Magic  = 0;
	uint16 MInfos = 0;

	fread(&Magic,  4, 1, f);
	fread(&MInfos, 2, 1, f);

	if (Magic != 0x5151B116)
	{
		printf("\033[31mERROR::Failed to parse visibility information file [%s] !\033[0m\n", Filename);	
		return;
	}

	Meshes.resize(MInfos);

	for (size_t inx = 0; inx < Meshes.size(); inx++)
	{ 
		FMeshVisibility &Mesh = Meshes[inx];
	
		fread(&Mesh.VFormat, 1, 1, f);

		uint32 VSize = 0;

		switch (Mesh.VFormat)
		{
			case FMesh::EVertexFormat::Simple: VSize = sizeof(FMesh::FVertex);      break;
			case FMesh::EVertexFormat::Color:  VSize = sizeof(FMesh::FVertexColor); break;
			case FMesh::EVertexFormat::UV:     VSize = sizeof(FMesh::FVertexUV);    break;
		}

		if (VSize == 0)
		{
			printf("\033[31mERROR::Failed to parse visibility information file [%s] !\033[0m\n", Filename);	
			Meshes.clear();
			break;
		}

		uint16 NumV = 0, NumF = 0;

		fread(&NumV, 2, 1, f);
		fread(&NumF, 2, 1, f);

		Mesh.Faces.resize(NumF);
		Mesh.Verts.resize(NumV * VSize);
		Mesh.Visis.resize(NumF/3, false);

		fread(&Mesh.Faces[0], Mesh.Faces.size() * 2, 1, f);
		fread(&Mesh.Verts[0], Mesh.Verts.size(), 1, f);

		uint32 VisibilityFaces = 0;
		fread(&VisibilityFaces, 4, 1, f);

		for (uint32 vi = 0; vi < VisibilityFaces; vi++)
		{
			uint32 fi = 0;

			fread(&fi, 4, 1, f);

			if (fi != vi)
			{
				printf("\033[31mERROR::Failed to parse visibility information file [%s] !\033[0m\n", Filename);	
				Meshes.clear();
				break;
			}

			FVector3D fa, fb, fc;
			uint32    p = 0;

			fread(&fa, 12, 1, f);
			fread(&fb, 12, 1, f);
			fread(&fc, 12, 1, f);
			fread(&p, 4, 1, f);

			if (p)
			{
				if (!Mesh.MarkAsVisible(fa, fb, fc))
				{
					printf("\033[31mERROR::Failed to parse visibility information file [%s] !\033[0m\n", Filename);	
					Meshes.clear();
					break;
				}
			}
		}
	}

	fclose(f);
	return;
}

FSceneVisibilityInfo::~FSceneVisibilityInfo()
{
	return;
}