// (c) MX^Add
#pragma once

#include "Exporter.h"
#include "SceneExporterMesh.h"
#include "RendererTypes/Mesh.h"

class FMeshVisibility
{
public:
	
	FMesh::EVertexFormat VFormat;
	std::vector<uint16>  Faces;
	std::vector<uint8>   Verts;
	std::vector<bool>    Visis;

	bool MarkAsVisible(const FVector3D &a, const FVector3D &b, const FVector3D &c)
	{
		for (size_t i = 0; i < Faces.size(); i += 3)
		{
			switch (VFormat)
			{
				case FMesh::EVertexFormat::Simple: 
					{
						const FMesh::FVertex *Vtx = (FMesh::FVertex *)&Verts[0];
						if (Vtx[Faces[i+0]].Pos == a && Vtx[Faces[i+1]].Pos == b && Vtx[Faces[i+2]].Pos == c)
						{
							Visis[i/3] = true;
							return true;
						}
					}
				break;

				case FMesh::EVertexFormat::Color:  
					{
						const FMesh::FVertexColor *Vtx = (FMesh::FVertexColor *)&Verts[0];
						if (Vtx[Faces[i+0]].Pos == a && Vtx[Faces[i+1]].Pos == b && Vtx[Faces[i+2]].Pos == c)
						{
							Visis[i/3] = true;
							return true;
						}
					}
				break;

				case FMesh::EVertexFormat::UV:
					{
						const FMesh::FVertexUV *Vtx = (FMesh::FVertexUV *)&Verts[0];
						if (Vtx[Faces[i+0]].Pos == a && Vtx[Faces[i+1]].Pos == b && Vtx[Faces[i+2]].Pos == c)
						{
							Visis[i/3] = true;
							return true;
						}
					}
				break;
			}			
		}

		return false;
	}
};

class FSceneVisibilityInfo
{
public:
	
	std::vector<FMeshVisibility> Meshes;

	FSceneVisibilityInfo(const char *Filename);
	~FSceneVisibilityInfo();
};
