// (c) MX^Add

#include "Font/BitmapFont.h"
#include "Renderer/FrameBuffer.h"

static const uint8 FontMask[128][10] = 
{
    // CtrlD font from https://8bitworkshop.com/bitmapfontgenerator/
    // 8x10, with offset==2 (range 0 - 127), MSB first, XYSwapped
    { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x30,0x78,0xFC,0x78,0x30,0x00,0x00,0x00 },{ 0x30,0xCC,0x30,0xCC,0x30,0xCC,0x30,0xCC,0x30,0xCC },{ 0xD0,0xD0,0xF0,0xDC,0xD8,0x1C,0x18,0x18,0x00,0x00 },{ 0xF0,0xC0,0xE0,0xDC,0xD8,0x1C,0x18,0x18,0x00,0x00 },{ 0x60,0xC0,0xC0,0xDC,0x74,0x18,0x14,0x14,0x00,0x00 },{ 0xC0,0xC0,0xC0,0xDC,0xF8,0x1C,0x18,0x18,0x00,0x00 },{ 0x00,0x30,0x58,0x78,0x30,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x20,0x20,0xF8,0x20,0x20,0x00,0xF8,0x00 },{ 0xC0,0xF0,0xD0,0xD8,0xD8,0x18,0x18,0x1C,0x00,0x00 },{ 0xA0,0xA0,0xE0,0x5C,0x5C,0x08,0x08,0x08,0x00,0x00 },{ 0x30,0x30,0x30,0x30,0xF0,0xF0,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0xF0,0xF0,0x30,0x30,0x30,0x30 },{ 0x00,0x00,0x00,0x00,0x3C,0x3C,0x30,0x30,0x30,0x30 },{ 0x30,0x30,0x30,0x30,0x3C,0x3C,0x00,0x00,0x00,0x00 },{ 0x30,0x30,0x30,0x30,0xFC,0xFC,0x30,0x30,0x30,0x30 },{ 0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0xFC,0xFC,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC },{ 0x30,0x30,0x30,0x30,0x3C,0x3C,0x30,0x30,0x30,0x30 },{ 0x30,0x30,0x30,0x30,0xF0,0xF0,0x30,0x30,0x30,0x30 },{ 0x30,0x30,0x30,0x30,0xFC,0xFC,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0xFC,0xFC,0x30,0x30,0x30,0x30 },{ 0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30 },{ 0x00,0x18,0x70,0xE0,0x70,0x18,0x00,0xF8,0x00,0x00 },{ 0x00,0xC0,0x70,0x38,0x70,0xC0,0x00,0xF8,0x00,0x00 },{ 0x00,0x00,0x00,0xF8,0xF8,0x50,0x50,0x50,0x00,0x00 },{ 0x00,0x00,0x18,0xF8,0x30,0xF8,0x60,0x00,0x00,0x00 },{ 0x18,0x30,0x30,0x78,0x30,0x60,0xF8,0xF8,0x00,0x00 },{ 0x00,0x00,0x00,0x70,0x70,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x20,0x30,0x30,0x20,0x20,0x00,0x20,0x00,0x00 },{ 0x58,0x58,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x50,0xF8,0x70,0x70,0xF8,0x50,0x00,0x00 },{ 0x00,0x20,0x78,0xE0,0xF8,0x38,0xF0,0x20,0x00,0x00 },{ 0x00,0x44,0xAC,0x58,0x30,0x68,0xD4,0x88,0x00,0x00 },{ 0x00,0x60,0xD0,0xD0,0x60,0xD4,0xD8,0x74,0x00,0x00 },{ 0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x10,0x30,0x60,0x60,0x60,0x60,0x60,0x30,0x10,0x00 },{ 0x40,0x60,0x30,0x30,0x30,0x30,0x30,0x60,0x40,0x00 },{ 0x00,0x00,0xA8,0x70,0x70,0x70,0xA8,0x00,0x00,0x00 },{ 0x00,0x00,0x20,0x20,0xF8,0x20,0x20,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x40,0x00 },{ 0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00 },{ 0x08,0x18,0x10,0x30,0x20,0x60,0x40,0xC0,0x80,0x00 },{ 0x00,0x70,0xD8,0xD8,0xF8,0xD8,0xD8,0x70,0x00,0x00 },{ 0x00,0x10,0x30,0x70,0x30,0x30,0x30,0x78,0x00,0x00 },{ 0x00,0x70,0x98,0x18,0x18,0x30,0x60,0xF8,0x00,0x00 },{ 0x00,0xF0,0x38,0x38,0xF0,0x38,0x38,0xF0,0x00,0x00 },{ 0x00,0x10,0x30,0x70,0xB0,0xF8,0x30,0x30,0x00,0x00 },{ 0x00,0xF0,0xC8,0xC0,0xF0,0x38,0xB8,0x70,0x00,0x00 },{ 0x00,0x30,0x60,0xC0,0xF0,0xD8,0xD8,0x70,0x00,0x00 },{ 0x00,0xF8,0xF8,0x10,0x30,0x20,0x60,0x40,0x00,0x00 },{ 0x00,0x70,0xD8,0xD8,0x70,0xD8,0xD8,0x70,0x00,0x00 },{ 0x00,0x70,0xD8,0xD8,0x78,0x18,0x30,0x60,0x00,0x00 },{ 0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x20,0x00,0x20,0x20,0x40,0x00,0x00 },{ 0x00,0x00,0x18,0x70,0xE0,0x70,0x18,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0xF8,0x00,0xF8,0x38,0x00,0x00,0x00 },{ 0x00,0x00,0xC0,0x70,0x38,0x70,0xC0,0x00,0x00,0x00 },{ 0x00,0x70,0x98,0x98,0x30,0x20,0x00,0x20,0x00,0x00 },{ 0x78,0xFC,0x84,0xB4,0xBC,0xBC,0x80,0x7C,0x00,0x00 },{ 0x00,0x20,0x70,0x50,0xF8,0xD8,0xD8,0xD8,0x00,0x00 },{ 0x00,0xF0,0xD8,0xD8,0xF0,0xD8,0xD8,0xF0,0x00,0x00 },{ 0x00,0x70,0xC8,0xC0,0xC0,0xC0,0xC8,0x70,0x00,0x00 },{ 0x00,0xE0,0xD0,0xD8,0xD8,0xD8,0xD0,0xE0,0x00,0x00 },{ 0x00,0xF8,0xC0,0xC0,0xF0,0xC0,0xC0,0xF8,0x00,0x00 },{ 0x00,0xF8,0xC0,0xC0,0xF0,0xC0,0xC0,0xC0,0x00,0x00 },{ 0x00,0x70,0xD8,0xC0,0xD8,0xC8,0xC8,0x78,0x00,0x00 },{ 0x00,0xD8,0xD8,0xD8,0xF8,0xD8,0xD8,0xD8,0x00,0x00 },{ 0x00,0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00,0x00 },{ 0x00,0x78,0x18,0x18,0x18,0x18,0x18,0xF0,0x00,0x00 },{ 0x00,0xC8,0xD0,0xE0,0xE0,0xF0,0xD8,0xC8,0x00,0x00 },{ 0x00,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xF8,0x00,0x00 },{ 0x00,0x88,0x88,0xD8,0xF8,0xF8,0xD8,0xD8,0x00,0x00 },{ 0x00,0xC8,0xC8,0xE8,0xE8,0xD8,0xD8,0xD8,0x00,0x00 },{ 0x00,0x70,0xD8,0xD8,0xD8,0xD8,0xD8,0x70,0x00,0x00 },{ 0x00,0xF0,0xD8,0xD8,0xF0,0xC0,0xC0,0xC0,0x00,0x00 },{ 0x00,0x70,0xD8,0xD8,0xD8,0xF8,0xD8,0x74,0x00,0x00 },{ 0x00,0xF0,0xD8,0xD8,0xF0,0xD8,0xD8,0xD8,0x00,0x00 },{ 0x00,0x70,0xC8,0xC0,0x70,0x18,0x98,0x70,0x00,0x00 },{ 0x00,0xFC,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00 },{ 0x00,0xD8,0xD8,0xD8,0xD8,0xD8,0xD8,0x70,0x00,0x00 },{ 0x00,0xD8,0xD8,0xD8,0xD8,0x50,0x70,0x20,0x00,0x00 },{ 0x00,0x88,0xA8,0xA8,0xF8,0xF8,0x70,0x50,0x00,0x00 },{ 0x00,0xD8,0xD8,0x50,0x20,0x50,0xD8,0xD8,0x00,0x00 },{ 0x00,0xD8,0xD8,0xD8,0x70,0x20,0x20,0x20,0x00,0x00 },{ 0x00,0xF8,0x38,0x30,0x20,0x60,0xE0,0xF8,0x00,0x00 },{ 0x70,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x70,0x00 },{ 0x80,0xC0,0x40,0x60,0x20,0x30,0x10,0x18,0x08,0x00 },{ 0x70,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x70,0x00 },{ 0x00,0x20,0x70,0xD8,0x88,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC },{ 0x00,0x20,0x30,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x70,0x18,0x78,0xD8,0x78,0x00,0x00 },{ 0xC0,0xC0,0xC0,0xF0,0xD8,0xD8,0xD8,0xF0,0x00,0x00 },{ 0x00,0x00,0x00,0x78,0xC0,0xC0,0xC0,0x78,0x00,0x00 },{ 0x18,0x18,0x18,0x78,0xD8,0xD8,0xD8,0x78,0x00,0x00 },{ 0x00,0x00,0x00,0x70,0xD8,0xF8,0xC0,0x78,0x00,0x00 },{ 0x38,0x60,0x60,0xF8,0x60,0x60,0x60,0x60,0x00,0x00 },{ 0x00,0x00,0x00,0x70,0xD8,0xD8,0xD8,0x78,0x18,0x70 },{ 0xC0,0xC0,0xC0,0xF0,0xD8,0xD8,0xD8,0xD8,0x00,0x00 },{ 0x30,0x30,0x00,0x70,0x30,0x30,0x30,0x30,0x00,0x00 },{ 0x30,0x30,0x00,0x70,0x30,0x30,0x30,0x30,0x30,0xE0 },{ 0x60,0x60,0x60,0x68,0x70,0x70,0x78,0x68,0x00,0x00 },{ 0x70,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00 },{ 0x00,0x00,0x00,0xD0,0xF8,0xF8,0xA8,0xA8,0x00,0x00 },{ 0x00,0x00,0x00,0xF0,0xD8,0xD8,0xD8,0xD8,0x00,0x00 },{ 0x00,0x00,0x00,0x70,0xD8,0xD8,0xD8,0x70,0x00,0x00 },{ 0x00,0x00,0x00,0xF0,0xD8,0xD8,0xD8,0xF0,0xC0,0xC0 },{ 0x00,0x00,0x00,0x78,0xD8,0xD8,0xD8,0x78,0x18,0x18 },{ 0x00,0x00,0x00,0xD0,0xE8,0xC0,0xC0,0xC0,0x00,0x00 },{ 0x00,0x00,0x00,0x78,0xC0,0x70,0x18,0xF0,0x00,0x00 },{ 0x00,0x60,0x60,0x78,0x60,0x60,0x60,0x38,0x00,0x00 },{ 0x00,0x00,0x00,0xD8,0xD8,0xD8,0xD8,0x78,0x00,0x00 },{ 0x00,0x00,0x00,0xD8,0xD8,0x50,0x70,0x20,0x00,0x00 },{ 0x00,0x00,0x00,0x88,0xA8,0xF8,0xF8,0x50,0x00,0x00 },{ 0x00,0x00,0x00,0xD8,0x50,0x20,0x50,0xD8,0x00,0x00 },{ 0x00,0x00,0x00,0xD8,0xD8,0xD8,0xD8,0x78,0x18,0x70 },{ 0x00,0x00,0x00,0xF8,0x18,0x30,0x60,0xF8,0x00,0x00 },{ 0x30,0x20,0x20,0x60,0xC0,0x60,0x20,0x20,0x30,0x00 },{ 0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00 },{ 0x60,0x20,0x20,0x30,0x18,0x30,0x20,0x20,0x60,0x00 },{ 0x00,0x00,0x00,0x00,0x6C,0xD8,0x00,0x00,0x00,0x00 },{ 0x00,0xF8,0xD8,0xD8,0xD8,0xD8,0xD8,0xF8,0x00,0x00 }

    // IBM CGA BIOS font from https://8bitworkshop.com/bitmapfontgenerator/
    // 8x10, with offset==1 (range 0 - 127), MSB first, XYSwapped
    // { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x7E,0x81,0xA5,0x81,0xBD,0x99,0x81,0x7E },{ 0x00,0x00,0x7E,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E },{ 0x00,0x00,0x6C,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00 },{ 0x00,0x00,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00 },{ 0x00,0x00,0x38,0x7C,0x38,0xFE,0xFE,0xD6,0x10,0x38 },{ 0x00,0x00,0x10,0x10,0x38,0x7C,0xFE,0x7C,0x10,0x38 },{ 0x00,0x00,0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00 },{ 0x00,0x00,0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF },{ 0x00,0x00,0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00 },{ 0x00,0x00,0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF },{ 0x00,0x00,0x0F,0x07,0x0F,0x7D,0xCC,0xCC,0xCC,0x78 },{ 0x00,0x00,0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18 },{ 0x00,0x00,0x3F,0x33,0x3F,0x30,0x30,0x70,0xF0,0xE0 },{ 0x00,0x00,0x7F,0x63,0x7F,0x63,0x63,0x67,0xE6,0xC0 },{ 0x00,0x00,0x18,0xDB,0x3C,0xE7,0xE7,0x3C,0xDB,0x18 },{ 0x00,0x00,0x80,0xE0,0xF8,0xFE,0xF8,0xE0,0x80,0x00 },{ 0x00,0x00,0x02,0x0E,0x3E,0xFE,0x3E,0x0E,0x02,0x00 },{ 0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x7E,0x3C,0x18 },{ 0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00 },{ 0x00,0x00,0x7F,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x00 },{ 0x00,0x00,0x3E,0x63,0x38,0x6C,0x6C,0x38,0xCC,0x78 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x00 },{ 0x00,0x00,0x18,0x3C,0x7E,0x18,0x7E,0x3C,0x18,0xFF },{ 0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x00 },{ 0x00,0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00 },{ 0x00,0x00,0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00 },{ 0x00,0x00,0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00 },{ 0x00,0x00,0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00 },{ 0x00,0x00,0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x00,0x00 },{ 0x00,0x00,0x00,0xFF,0xFF,0x7E,0x3C,0x18,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00 },{ 0x00,0x00,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00 },{ 0x00,0x00,0x30,0x7C,0xC0,0x78,0x0C,0xF8,0x30,0x00 },{ 0x00,0x00,0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00 },{ 0x00,0x00,0x38,0x6C,0x38,0x76,0xDC,0xCC,0x76,0x00 },{ 0x00,0x00,0x60,0x60,0xC0,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00 },{ 0x00,0x00,0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00 },{ 0x00,0x00,0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00 },{ 0x00,0x00,0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60 },{ 0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00 },{ 0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00 },{ 0x00,0x00,0x7C,0xC6,0xCE,0xDE,0xF6,0xE6,0x7C,0x00 },{ 0x00,0x00,0x30,0x70,0x30,0x30,0x30,0x30,0xFC,0x00 },{ 0x00,0x00,0x78,0xCC,0x0C,0x38,0x60,0xC4,0xFC,0x00 },{ 0x00,0x00,0x78,0xCC,0x0C,0x38,0x0C,0xCC,0x78,0x00 },{ 0x00,0x00,0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x1E,0x00 },{ 0x00,0x00,0xFC,0xC0,0xF8,0x0C,0x0C,0xCC,0x78,0x00 },{ 0x00,0x00,0x38,0x60,0xC0,0xF8,0xCC,0xCC,0x78,0x00 },{ 0x00,0x00,0xFC,0xCC,0x0C,0x18,0x30,0x30,0x30,0x00 },{ 0x00,0x00,0x78,0xCC,0xCC,0x78,0xCC,0xCC,0x78,0x00 },{ 0x00,0x00,0x78,0xCC,0xCC,0x7C,0x0C,0x18,0x70,0x00 },{ 0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00 },{ 0x00,0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x60,0x00 },{ 0x00,0x00,0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00 },{ 0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00 },{ 0x00,0x00,0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00 },{ 0x00,0x00,0x78,0xCC,0x0C,0x18,0x30,0x00,0x30,0x00 },{ 0x00,0x00,0x7C,0xC6,0xDE,0xDE,0xDE,0xC0,0x78,0x00 },{ 0x00,0x00,0x30,0x78,0xCC,0xCC,0xFC,0xCC,0xCC,0x00 },{ 0x00,0x00,0xFC,0x66,0x66,0x7C,0x66,0x66,0xFC,0x00 },{ 0x00,0x00,0x3C,0x66,0xC0,0xC0,0xC0,0x66,0x3C,0x00 },{ 0x00,0x00,0xF8,0x6C,0x66,0x66,0x66,0x6C,0xF8,0x00 },{ 0x00,0x00,0xFE,0x62,0x68,0x78,0x68,0x62,0xFE,0x00 },{ 0x00,0x00,0xFE,0x62,0x68,0x78,0x68,0x60,0xF0,0x00 },{ 0x00,0x00,0x3C,0x66,0xC0,0xC0,0xCE,0x66,0x3E,0x00 },{ 0x00,0x00,0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00 },{ 0x00,0x00,0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00 },{ 0x00,0x00,0x1E,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00 },{ 0x00,0x00,0xE6,0x66,0x6C,0x78,0x6C,0x66,0xE6,0x00 },{ 0x00,0x00,0xF0,0x60,0x60,0x60,0x62,0x66,0xFE,0x00 },{ 0x00,0x00,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0x00 },{ 0x00,0x00,0xC6,0xE6,0xF6,0xDE,0xCE,0xC6,0xC6,0x00 },{ 0x00,0x00,0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x38,0x00 },{ 0x00,0x00,0xFC,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00 },{ 0x00,0x00,0x78,0xCC,0xCC,0xCC,0xDC,0x78,0x1C,0x00 },{ 0x00,0x00,0xFC,0x66,0x66,0x7C,0x6C,0x66,0xE6,0x00 },{ 0x00,0x00,0x78,0xCC,0x60,0x30,0x18,0xCC,0x78,0x00 },{ 0x00,0x00,0xFC,0xB4,0x30,0x30,0x30,0x30,0x78,0x00 },{ 0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00 },{ 0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x30,0x00 },{ 0x00,0x00,0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00 },{ 0x00,0x00,0xC6,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0x00 },{ 0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x30,0x78,0x00 },{ 0x00,0x00,0xFE,0xC6,0x8C,0x18,0x32,0x66,0xFE,0x00 },{ 0x00,0x00,0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00 },{ 0x00,0x00,0xC0,0x60,0x30,0x18,0x0C,0x06,0x02,0x00 },{ 0x00,0x00,0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00 },{ 0x00,0x00,0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF },{ 0x00,0x00,0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x00,0x78,0x0C,0x7C,0xCC,0x76,0x00 },{ 0x00,0x00,0xE0,0x60,0x60,0x7C,0x66,0x66,0xDC,0x00 },{ 0x00,0x00,0x00,0x00,0x78,0xCC,0xC0,0xCC,0x78,0x00 },{ 0x00,0x00,0x1C,0x0C,0x0C,0x7C,0xCC,0xCC,0x76,0x00 },{ 0x00,0x00,0x00,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00 },{ 0x00,0x00,0x38,0x6C,0x60,0xF0,0x60,0x60,0xF0,0x00 },{ 0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0xF8 },{ 0x00,0x00,0xE0,0x60,0x6C,0x76,0x66,0x66,0xE6,0x00 },{ 0x00,0x00,0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00 },{ 0x00,0x00,0x0C,0x00,0x0C,0x0C,0x0C,0xCC,0xCC,0x78 },{ 0x00,0x00,0xE0,0x60,0x66,0x6C,0x78,0x6C,0xE6,0x00 },{ 0x00,0x00,0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00 },{ 0x00,0x00,0x00,0x00,0xCC,0xFE,0xFE,0xD6,0xC6,0x00 },{ 0x00,0x00,0x00,0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0x00 },{ 0x00,0x00,0x00,0x00,0x78,0xCC,0xCC,0xCC,0x78,0x00 },{ 0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x7C,0x60,0xF0 },{ 0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0x1E },{ 0x00,0x00,0x00,0x00,0xDC,0x76,0x66,0x60,0xF0,0x00 },{ 0x00,0x00,0x00,0x00,0x7C,0xC0,0x78,0x0C,0xF8,0x00 },{ 0x00,0x00,0x10,0x30,0x7C,0x30,0x30,0x34,0x18,0x00 },{ 0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0x76,0x00 },{ 0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x00 },{ 0x00,0x00,0x00,0x00,0xC6,0xD6,0xFE,0xFE,0x6C,0x00 },{ 0x00,0x00,0x00,0x00,0xC6,0x6C,0x38,0x6C,0xC6,0x00 },{ 0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8 },{ 0x00,0x00,0x00,0x00,0xFC,0x98,0x30,0x64,0xFC,0x00 },{ 0x00,0x00,0x1C,0x30,0x30,0xE0,0x30,0x30,0x1C,0x00 },{ 0x00,0x00,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00 },{ 0x00,0x00,0xE0,0x30,0x30,0x1C,0x30,0x30,0xE0,0x00 },{ 0x00,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00 },{ 0x00,0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0x00 }
};

void PrintString(const char* s, uint32 l, sint32 offx, sint32 offy, uint16 c, uint16 *ExtBuffer)
{
    if (offy <= -10 || offy >= RasterizerSizeY)
        return;

    __restrict uint16 *Video = ExtBuffer ? ExtBuffer : RasterizerFramebuffer;

    for (uint32 sz = 0; sz < l; sz++)
    {
        uint8 ch = uint8(s[sz]);
        if (ch >= 128)
            continue;

        sint32 fbx = sint32(sz<<3) + offx;

        if (fbx <= -8)
            continue;

        if (fbx >= RasterizerSizeX)
            break;

        const uint8 *CharMask = &FontMask[ch][0];

        for (sint32 y = 0; y < 10; y++)
        {
            uint8 Mask = 0x80;
            uint8 ChaM = CharMask[y];

            sint32 fby = y + offy;

            if (fby < 0 || fby >= RasterizerSizeY)
                continue;

            uint16 *VLine = &Video[fby * RasterizerSizeX];

            #ifdef PI_PICO_TARGET
            #pragma GCC unroll 8
            #endif
            for (sint32 x = 0; x < 8; x++, Mask >>= 1)
            {
                if (ChaM & Mask && fbx + x >= 0 && fbx + x < RasterizerSizeX)
                    VLine[fbx + x] = c;
            }
        }
    }

    return;
}

void PrintString2X(const char* s, uint32 l, sint32 offx, sint32 offy, uint16 c, uint16 *ExtBuffer)
{
    if (offy <= -20 || offy >= RasterizerSizeY)
        return;

    __restrict uint16 *Video = ExtBuffer ? ExtBuffer : RasterizerFramebuffer;
    uint32 cc = uint32(c) | (uint32(c) << 16);

    for (uint32 sz = 0; sz < l; sz++)
    {
        uint8 ch = uint8(s[sz]);
        if (ch >= 128)
            continue;

        sint32 fbx = sint32(sz<<4) + offx;

        if (fbx <= -16)
            continue;

        if (fbx >= RasterizerSizeX)
            break;

        const uint8 *CharMask = &FontMask[ch][0];

        for (sint32 y = 0; y < 20; y++)
        {
            uint8 Mask = 0x80;
            uint8 ChaM = CharMask[y>>1];

            sint32 fby = y + offy;

            if (fby < 0 || fby >= RasterizerSizeY)
                continue;

            uint16 *VLine = &Video[fby * RasterizerSizeX];

            #ifdef PI_PICO_TARGET
            #pragma GCC unroll 8
            #endif
            for (sint32 x = 0; x < 16; x+=2, Mask >>= 1)
            {
                if (ChaM & Mask && fbx + x >= 0 && fbx + x < RasterizerSizeX-1)
                   *((uint32 *)&VLine[fbx + x]) = cc;
            }
        }
    }

    return;
}

void PrintStringBlend(const char* s, uint32 l, sint32 offx, sint32 offy, uint16 c, uint8 Alpha, uint16 *ExtBuffer)
{
    if (Alpha >= 0xF8)
    {
        PrintString(s, l, offx, offy, c, ExtBuffer);
        return;
    }

    if (offy <= -10 || offy >= RasterizerSizeY || Alpha <= 0x07)
        return;

    __restrict uint16 *Video = ExtBuffer ? ExtBuffer : RasterizerFramebuffer;

    const sint32 cr =  c >> 11;
    const sint32 cg = (c >> 5) & 0x3F;
    const sint32 cb =  c & 0x1F;
    const sint32 al = sint32(Alpha);

    for (uint32 sz = 0; sz < l; sz++)
    {
        uint8 ch = uint8(s[sz]);
        if (ch >= 128)
            continue;

        sint32 fbx = sint32(sz<<3) + offx;

        if (fbx <= -8)
            continue;

        if (fbx >= RasterizerSizeX)
            break;

        const uint8 *CharMask = &FontMask[ch][0];

        for (sint32 y = 0; y < 10; y++)
        {
            uint8 Mask = 0x80;
            uint8 ChaM = CharMask[y];

            sint32 fby = y + offy;

            if (fby < 0 || fby >= RasterizerSizeY)
                continue;

            uint16 *VLine = &Video[fby * RasterizerSizeX];

            #ifdef PI_PICO_TARGET
            #pragma GCC unroll 8
            #endif
            for (sint32 x = 0; x < 8; x++, Mask >>= 1)
            {
                if (ChaM & Mask && fbx + x >= 0 && fbx + x < RasterizerSizeX)
                {
                    const uint16 dc = VLine[fbx + x];
                    const sint32 dr =  dc >> 11;
                    const sint32 dg = (dc >> 5) & 0x3F;
                    const sint32 db =  dc & 0x1F;

                    VLine[fbx + x] = ((dr + (((cr - dr) * al) >> 8)) << 11) |
                                     ((dg + (((cg - dg) * al) >> 8)) <<  5) |
                                      (db + (((cb - db) * al) >> 8))        ;
                }
            }
        }
    }

    return;
}

void PrintString2XBlend(const char* s, uint32 l, sint32 offx, sint32 offy, uint16 c, uint8 Alpha, uint16* ExtBuffer)
{
    if (Alpha >= 0xF8)
    {
        PrintString2X(s, l, offx, offy, c, ExtBuffer);
        return;
    }

    if (offy <= -20 || offy >= RasterizerSizeY || Alpha <= 7)
        return;

    __restrict uint16 *Video = ExtBuffer ? ExtBuffer : RasterizerFramebuffer;

    const sint32 cr =  c >> 11;
    const sint32 cg = (c >> 5) & 0x3F;
    const sint32 cb =  c & 0x1F;
    const sint32 al = sint32(Alpha);

    for (uint32 sz = 0; sz < l; sz++)
    {
        uint8 ch = uint8(s[sz]);
        if (ch >= 128)
            continue;

        sint32 fbx = sint32(sz<<4) + offx;

        if (fbx <= -16)
            continue;

        if (fbx >= RasterizerSizeX)
            break;

        const uint8 *CharMask = &FontMask[ch][0];

        for (sint32 y = 0; y < 20; y++)
        {
            uint8 Mask = 0x80;
            uint8 ChaM = CharMask[y>>1];

            sint32 fby = y + offy;

            if (fby < 0 || fby >= RasterizerSizeY)
                continue;

            uint16 *VLine = &Video[fby * RasterizerSizeX];

            #ifdef PI_PICO_TARGET
            #pragma GCC unroll 8
            #endif
            for (sint32 x = 0; x < 16; x++)
            {
                if (ChaM & Mask && fbx + x >= 0 && fbx + x < RasterizerSizeX)
                {
                    const uint16 dc = VLine[fbx + x];
                    const sint32 dr =  dc >> 11;
                    const sint32 dg = (dc >> 5) & 0x3F;
                    const sint32 db =  dc & 0x1F;

                    VLine[fbx + x] = ((dr + (((cr - dr) * al) >> 8)) << 11) |
                                     ((dg + (((cg - dg) * al) >> 8)) <<  5) |
                                      (db + (((cb - db) * al) >> 8))        ;
                }

                if (x & 1)
                    Mask >>= 1;
            }
        }
    }

    return;
}

void PrintStringTex(const char* s, uint32 l, sint32 offx, sint32 offy, const uint16* Tex, uint16* ExtBuffer)
{
    if (offy <= -10 || offy >= RasterizerSizeY)
        return;

    __restrict uint16 *Video = ExtBuffer ? ExtBuffer : RasterizerFramebuffer;

    for (uint32 sz = 0; sz < l; sz++)
    {
        uint8 ch = uint8(s[sz]);
        if (ch >= 128)
            continue;

        sint32 fbx = sint32(sz<<3) + offx;

        if (fbx <= -8)
            continue;

        if (fbx >= RasterizerSizeX)
            break;

        const uint8 *CharMask = &FontMask[ch][0];

        for (sint32 y = 0; y < 10; y++)
        {
            uint8 Mask = 0x80;
            uint8 ChaM = CharMask[y];

            sint32 fby = y + offy;

            if (fby < 0 || fby >= RasterizerSizeY)
                continue;

            uint16 *VLine = &Video[fby * RasterizerSizeX];
            const uint16 *TLine = &Tex[y << 3];

            #ifdef PI_PICO_TARGET
            #pragma GCC unroll 8
            #endif
            for (sint32 x = 0; x < 8; x++, Mask >>= 1)
            {
                if (ChaM & Mask && fbx + x >= 0 && fbx + x < RasterizerSizeX)
                    VLine[fbx + x] = TLine[x];
            }
        }
    }

    return;
}

void PrintString2XTex(const char* s, uint32 l, sint32 offx, sint32 offy, const uint16* Tex, uint16* ExtBuffer)
{
    if (offy <= -20 || offy >= RasterizerSizeY)
        return;

    __restrict uint16 *Video = ExtBuffer ? ExtBuffer : RasterizerFramebuffer;
    
    for (uint32 sz = 0; sz < l; sz++)
    {
        uint8 ch = uint8(s[sz]);
        if (ch >= 128)
            continue;

        sint32 fbx = sint32(sz<<4) + offx;

        if (fbx <= -16)
            continue;

        if (fbx >= RasterizerSizeX)
            break;

        const uint8 *CharMask = &FontMask[ch][0];

        for (sint32 y = 0; y < 20; y++)
        {
            uint8 Mask = 0x80;
            uint8 ChaM = CharMask[y>>1];

            sint32 fby = y + offy;

            if (fby < 0 || fby >= RasterizerSizeY)
                continue;

            uint16 *VLine = &Video[fby * RasterizerSizeX];
            const uint16* TLine = &Tex[y << 4];

            #ifdef PI_PICO_TARGET
            #pragma GCC unroll 8
            #endif
            for (sint32 x = 0; x < 16; x+=2, Mask >>= 1)
            {
                if (ChaM & Mask && fbx + x >= 0 && fbx + x < RasterizerSizeX - 1)
                {
                    VLine[fbx + x + 0] = TLine[x + 0];
                    VLine[fbx + x + 1] = TLine[x + 1];
                }
            }
        }
    }

    return;
}

void PrintStringBlendTex(const char* s, uint32 l, sint32 offx, sint32 offy, const uint16* Tex, uint8 Alpha, uint16* ExtBuffer)
{
    if (Alpha >= 0xF8)
    {
        PrintStringTex(s, l, offx, offy, Tex, ExtBuffer);
        return;
    }

    if (offy <= -10 || offy >= RasterizerSizeY || Alpha <= 0x07)
        return;

    __restrict uint16 *Video = ExtBuffer ? ExtBuffer : RasterizerFramebuffer;

    const sint32 al = sint32(Alpha);

    for (uint32 sz = 0; sz < l; sz++)
    {
        uint8 ch = uint8(s[sz]);
        if (ch >= 128)
            continue;

        sint32 fbx = sint32(sz<<3) + offx;

        if (fbx <= -8)
            continue;

        if (fbx >= RasterizerSizeX)
            break;

        const uint8 *CharMask = &FontMask[ch][0];

        for (sint32 y = 0; y < 10; y++)
        {
            uint8 Mask = 0x80;
            uint8 ChaM = CharMask[y];

            sint32 fby = y + offy;

            if (fby < 0 || fby >= RasterizerSizeY)
                continue;

            uint16 *VLine = &Video[fby * RasterizerSizeX];
            const uint16* TLine = &Tex[y << 3];

            #ifdef PI_PICO_TARGET
            #pragma GCC unroll 8
            #endif
            for (sint32 x = 0; x < 8; x++, Mask >>= 1)
            {
                if (ChaM & Mask && fbx + x >= 0 && fbx + x < RasterizerSizeX)
                {
                    const uint16 c  = TLine[x];
                    const sint32 cr = c >> 11;
                    const sint32 cg =(c >> 5) & 0x3F;
                    const sint32 cb = c & 0x1F;

                    const uint16 dc = VLine[fbx + x];
                    const sint32 dr =  dc >> 11;
                    const sint32 dg = (dc >> 5) & 0x3F;
                    const sint32 db =  dc & 0x1F;

                    VLine[fbx + x] = ((dr + (((cr - dr) * al) >> 8)) << 11) |
                                     ((dg + (((cg - dg) * al) >> 8)) <<  5) |
                                      (db + (((cb - db) * al) >> 8))        ;
                }
            }
        }
    }

    return;
}

void PrintString2XBlendTex(const char* s, uint32 l, sint32 offx, sint32 offy, const uint16* Tex, uint8 Alpha, uint16* ExtBuffer)
{
    if (Alpha >= 0xF8)
    {
        PrintString2XTex(s, l, offx, offy, Tex, ExtBuffer);
        return;
    }

    if (offy <= -20 || offy >= RasterizerSizeY || Alpha <= 7)
        return;

    __restrict uint16 *Video = ExtBuffer ? ExtBuffer : RasterizerFramebuffer;

    const sint32 al = sint32(Alpha);

    for (uint32 sz = 0; sz < l; sz++)
    {
        uint8 ch = uint8(s[sz]);
        if (ch >= 128)
            continue;

        sint32 fbx = sint32(sz<<4) + offx;

        if (fbx <= -16)
            continue;

        if (fbx >= RasterizerSizeX)
            break;

        const uint8 *CharMask = &FontMask[ch][0];

        for (sint32 y = 0; y < 20; y++)
        {
            uint8 Mask = 0x80;
            uint8 ChaM = CharMask[y>>1];

            sint32 fby = y + offy;

            if (fby < 0 || fby >= RasterizerSizeY)
                continue;

            uint16 *VLine = &Video[fby * RasterizerSizeX];
            const uint16* TLine = &Tex[y << 4];

            #ifdef PI_PICO_TARGET
            #pragma GCC unroll 8
            #endif
            for (sint32 x = 0; x < 16; x++)
            {
                if (ChaM & Mask && fbx + x >= 0 && fbx + x < RasterizerSizeX)
                {
                    const uint16 c  = TLine[x];
                    const sint32 cr = c >> 11;
                    const sint32 cg =(c >> 5) & 0x3F;
                    const sint32 cb = c & 0x1F;

                    const uint16 dc = VLine[fbx + x];
                    const sint32 dr =  dc >> 11;
                    const sint32 dg = (dc >> 5) & 0x3F;
                    const sint32 db =  dc & 0x1F;

                    VLine[fbx + x] = ((dr + (((cr - dr) * al) >> 8)) << 11) |
                                     ((dg + (((cg - dg) * al) >> 8)) <<  5) |
                                      (db + (((cb - db) * al) >> 8))        ;
                }

                if (x & 1)
                    Mask >>= 1;
            }
        }
    }

    return;
}