// (c) MX^Add

#include "ModPlayer.h"
#include "ModData.h"

#define POCKETMOD_IMPLEMENTATION

#include "pocketmod.h"

static pocketmod_context PlayerContext;
static bool				 MusicInitDone;
static constexpr uint32  InternalSamplesCount = 256; // NOTE::On PICO it should be AUDIO_STATIC_BUFFER_SIZE_CONSUMER in size for best performance
static uint32            InternalSamplesLeft  = 0;
static uint32            InternalSamplesOffset= 0;
static float			 InternalSamples[InternalSamplesCount * 2]; // Temporary buffer for samples conversion

static inline void ConvertSamples(sint16 *Tgt, const float *Src, uint32 Num)
{ 
	for (uint32 i = 0; i < Num; i++, Tgt++, Src++)
	{
		float v = *Src;
		if (v < -1.0f)
		   *Tgt = -32767;
		else
		if (v > 1.0f)
			*Tgt = 32767;
		else
			*Tgt = sint16(v * 32767.0f);
	}

	return;
}

void MODInitializePlayerData()
{
	MusicInitDone = pocketmod_init(&PlayerContext, MusicData, sizeof(MusicData), 44100) != 0;
	return;
}

uint32 MODFetchSamples(sint16 *Samples, uint32 Count)
{
	if (!MusicInitDone)
	{
		memset(Samples, 0, Count * sizeof(sint16) * 2);
		return Count;
	}

	uint32 Result = 0;

	while (Count)
	{
		if (InternalSamplesLeft)
		{
			uint32 ToCopy = MIN(InternalSamplesLeft, Count);

			ConvertSamples(Samples, &InternalSamples[InternalSamplesOffset * 2], ToCopy * 2);

			InternalSamplesLeft   -= ToCopy;
			InternalSamplesOffset += ToCopy;
			Result                += ToCopy;
			Count                 -= ToCopy;
			Samples               += ToCopy * 2;
		}
		else
		{
			InternalSamplesOffset  = 0;
			InternalSamplesLeft    = pocketmod_render(&PlayerContext, InternalSamples, InternalSamplesCount * sizeof(float) * 2) / (sizeof(float) * 2);

			// In case of failed generation, just play silence
			if (InternalSamplesLeft == 0)
			{
				memset(InternalSamples, 0, InternalSamplesCount * sizeof(float) * 2);
				InternalSamplesLeft = InternalSamplesCount;
			}
		}
	}

	return Result;
}
