//
// SDK based helper classes
//

#pragma once
#include <stdint.h>
#include <climits>
#include "pico/time.h"

#define PIMORONI_I2C_DEFAULT_INSTANCE i2c0
#define PIMORONI_SPI_DEFAULT_INSTANCE spi0

namespace pimoroni 
{
	static const unsigned int PIN_UNUSED = INT_MAX;

	// I2C
	static const unsigned int I2C_DEFAULT_BAUDRATE = 400000;
	static const unsigned int I2C_DEFAULT_SDA = 20;
	static const unsigned int I2C_DEFAULT_SCL = 21;
	static const unsigned int I2C_DEFAULT_INT = 22;

	static const unsigned int I2C_BG_SDA = 4;
	static const unsigned int I2C_BG_SCL = 5;
	static const unsigned int I2C_BG_INT = 3;

	static const unsigned int I2C_HEADER_SDA = 20;
	static const unsigned int I2C_HEADER_SCL = 21;
	static const unsigned int I2C_HEADER_INT = 19;

	// SPI
	static const unsigned int SPI_DEFAULT_MOSI = 19;
	static const unsigned int SPI_DEFAULT_MISO = 16;
	static const unsigned int SPI_DEFAULT_DC = 16;
	static const unsigned int SPI_DEFAULT_SCK = 18;

	static const unsigned int SPI_BG_FRONT_PWM = 20;
	static const unsigned int SPI_BG_FRONT_CS = 17;

	static const unsigned int SPI_BG_BACK_PWM = 21;
	static const unsigned int SPI_BG_BACK_CS = 22;

	enum BG_SPI_SLOT 
	{
		BG_SPI_FRONT,
		BG_SPI_BACK,
		PICO_EXPLORER_ONBOARD
	};

	enum BOARD 
	{
		BREAKOUT_GARDEN,
		PICO_EXPLORER,
		PLASMA_STICK,
		PLASMA_2040,
		INTERSTATE_75,
		SERVO_2040,
		MOTOR_2040
	};

	enum Rotation 
	{
		ROTATE_0 = 0,
		ROTATE_90 = 90,
		ROTATE_180 = 180,
		ROTATE_270 = 270
	};

	enum Polarity 
	{
		ACTIVE_LOW = 0,
		ACTIVE_HIGH = 1
	};

	enum Direction 
	{
		NORMAL_DIR = 0,
		REVERSED_DIR = 1,
	};

	inline uint32_t millis() 
	{
		return to_ms_since_boot(get_absolute_time());
	}

	struct pin_pair 
	{
		union 
		{
			uint8_t first;
			uint8_t a;
			uint8_t positive;
			uint8_t phase;
		};

		union 
		{
			uint8_t second;
			uint8_t b;
			uint8_t negative;
			uint8_t enable;
		};

		constexpr pin_pair() : first(0), second(0) {}
		constexpr pin_pair(uint8_t _first, uint8_t _second) : first(_first), second(_second) {}
	};

	struct bool_pair 
	{
		union 
		{
			bool first;
			bool a;
		};

		union 
		{
			bool second;
			bool b;
		};

		bool_pair() : first(false), second(false) {}
		bool_pair(bool _first, bool _second) : first(_first), second(_second) {}
	};
}
