// (c) MX^Add

#include "Renderer/FrameBuffer.h"

uint16 *RasterizerFramebuffer; // RGB565
uint16 *RasterizerDepthbuffer; // Fixpoint
uint8  *RasterizerScratchPad;  // ScratchPad

static_assert(RasterizerSizeX == PhysicalScreenSizeX, "RasterizerSizeX != PhysicalScreenSizeX !");

alignas(4) static uint16 __RasterizerBlock[(((RasterizerSizeX*RasterizerSizeY) * 2) + (2 * RasterizerSizeX)) + (ScratchPadSize/2)];

static void (*__FBWriteBarrierCallback)(void);

void InitializeFramebuffer()
{
	RasterizerFramebuffer = &__RasterizerBlock[1 * RasterizerSizeX];
	RasterizerDepthbuffer = &__RasterizerBlock[(2 * RasterizerSizeX) + (RasterizerSizeX*RasterizerSizeY)];
	RasterizerScratchPad  = (uint8 *)&__RasterizerBlock[(((RasterizerSizeX * RasterizerSizeY) * 2) + (2 * RasterizerSizeX))];
	return;
}

void SetColorWriteBarrier(void (*callback)(void))
{
	__FBWriteBarrierCallback = callback;
	return;
}

void TriggerColorWriteBarrier()
{
	if (__FBWriteBarrierCallback)
	{
	    __FBWriteBarrierCallback();
		__FBWriteBarrierCallback = nullptr;
	}
	return;
}

