// (c) MX^Add
#pragma once

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"

constexpr sint32 RasterizerSizeX	 = 320;
constexpr sint32 RasterizerSizeY	 = 200;
constexpr sint32 PhysicalScreenSizeX = 320;
constexpr sint32 PhysicalScreenSizeY = 240;
constexpr sint32 ScratchPadSize      = 32768;
constexpr Scalar HalfScreenX		 = Scalar(RasterizerSizeX/2);
constexpr Scalar HalfScreenY		 =-Scalar(RasterizerSizeY/2);

extern void InitializeFramebuffer();
extern void SetColorWriteBarrier(void (*callback)(void));
extern void TriggerColorWriteBarrier();

extern uint16 *RasterizerFramebuffer; // RGB565
extern uint16 *RasterizerDepthbuffer; // ZBuffer
extern uint8  *RasterizerScratchPad;  // ScratchPad

