// (c) MX^Add
#pragma once

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"

enum class EPostEffect : uint8
{
	None		= 0,
	Blur		= 1,
	FadeToBlack = 2,
	FadeToColor = 3,
	BlurFade	= 4,
};

inline uint32 MakePostEffect(EPostEffect Efx = EPostEffect::None, uint8 Amount = 0xFF, uint16 Data = 0xFFFF)
{
	return (uint32(Efx) << 8) | uint32(Amount) | (uint32(Data) << 16);
}

extern void DoPostEfx(uint32 PostEfx, uint16 *FrontBuffer);

extern void BlitImage(sint32 offx, sint32 offy, const uint16 *ImageData, const uint32 ImageSizeX, const uint32 ImageSizeY, bool ColorKey = false);

extern void BlitImage(sint32 offx, sint32 offy, uint8 Amount, const uint16 *ImageData, const uint32 ImageSizeX, const uint32 ImageSizeY, bool ColorKey = false);
