// (c) MX^Add

#include "RendererTypes/Curve.h"

FCurveFixed::FCurveFixed()
{
	Value = FixedZero;
	Keys  = 0;
	return;
}

Scalar FCurveFixed::Eval(const uint8 *Base, uint16 Frame) const
{
	if (Keys == 0)
		return Value;

	const uint8 *Buffer = Base + (uint32(Keys) << 3);

	return Eval((const FKeys *)(Buffer+4), ((const uint16 *)Buffer)[0], Frame);
}

Scalar FCurveFixed::Eval(const FKeys *KBuff, uint16 Num, uint16 Frame)
{
	if (Frame <= KBuff[0].f)
		return KBuff[0].v;
		
	if (Frame >= KBuff[Num-1].f)
		return KBuff[Num-1].v;

	const FKeys *BeginIt = &KBuff[0];
	const FKeys *EndIt   = &KBuff[Num-1];

	uint32 MIt = 0;
	uint32 BIt = 0;
	uint32 EIt = uint32(EndIt - BeginIt);
	const FKeys *PrevFrame = nullptr;

	while(1)
	{
		if ((EIt - BIt) < 2)
		{
			if ((BeginIt+EIt)->f <= Frame)
			{
				PrevFrame = (BeginIt+EIt);
				break;
			}
                 
			PrevFrame = (BeginIt+BIt);
			break;
		}

		MIt = BIt + ((EIt - BIt) >> 1);

		if ((BeginIt+MIt)->f >= Frame)
			EIt = MIt;
		else
			BIt = MIt;
	}
          
	const FKeys *NextFrame = PrevFrame + 1;

	if (NextFrame->f == PrevFrame->f)
		return PrevFrame->v;

	Scalar t = Scalar(Frame - PrevFrame->f) / Scalar(NextFrame->f - PrevFrame->f);

	return FScalar::Lerp(PrevFrame->v, NextFrame->v, t);
}

FCurveQuat::FCurveQuat()
{
	Value = FVector4D(FixedZero, FixedZero, FixedZero, FixedOne);
	Keys  = 0;
	return;
}

FVector4D FCurveQuat::Eval(const uint8* Base, uint16 Frame) const
{
	if (Keys == 0)
		return Value;

	const uint8 *Buffer = Base + (uint32(Keys) << 3);

	return Eval((const FKeys *)(Buffer+4), ((const uint16 *)Buffer)[0], Frame);
}

FVector4D FCurveQuat::Eval(const FKeys *KBuff, uint16 Num, uint16 Frame)
{
	if (Frame <= KBuff[0].f)
		return KBuff[0].v;
		
	if (Frame >= KBuff[Num-1].f)
		return KBuff[Num-1].v;

	const FKeys *BeginIt = &KBuff[0];
	const FKeys *EndIt   = &KBuff[Num-1];

	uint32 MIt = 0;
	uint32 BIt = 0;
	uint32 EIt = uint32(EndIt - BeginIt);
	const FKeys *PrevFrame = nullptr;

	while(1)
	{
		if ((EIt - BIt) < 2)
		{
			if ((BeginIt+EIt)->f <= Frame)
			{
				PrevFrame = (BeginIt+EIt);
				break;
			}
                 
			PrevFrame = (BeginIt+BIt);
			break;
		}

		MIt = BIt + ((EIt - BIt) >> 1);

		if ((BeginIt+MIt)->f >= Frame)
			EIt = MIt;
		else
			BIt = MIt;
	}
          
	const FKeys *NextFrame = PrevFrame + 1;

	if (NextFrame->f == PrevFrame->f)
		return PrevFrame->v;

#ifndef PI_PICO_TARGET
	FVector4D Result; Result.Slerp(PrevFrame->v, NextFrame->v, Scalar(Frame - PrevFrame->f) / Scalar(NextFrame->f - PrevFrame->f));
	return Result;
#else

	// NOTE::ARM compiler does some crazy shit with the above code on O levels above 1, so it's inlined there and optimalization is disabled.
	//       This is coused by the requirement of float to be 4 aligned, but we have packed structs, and float's are 2 aligned not 4

	Scalar            t = Scalar(Frame - PrevFrame->f) / Scalar(NextFrame->f - PrevFrame->f);
	const FVector4D &a = PrevFrame->v;
		  FVector4D  b = NextFrame->v;
		  Scalar cosTht = a.x*b.x + a.y*b.y + a.z*b.z + a.w*b.w;

	if (cosTht < 0)
	{
		b      = -b;
		cosTht = -cosTht;
	}

	if (cosTht > FixedSlerpEpsilon)
	{
		FVector4D  r = a + (b-a) * t;
				   r.Normalize();
		return r;
	}
	
	Scalar theta    = FScalar::ACos(cosTht);
	Scalar sinTheta = FScalar::Sin(theta);
	Scalar scaleA   = FScalar::Sin((FixedOne - t) * theta) / sinTheta;
	Scalar scaleB   = FScalar::Sin(t * theta) / sinTheta;

	return a * scaleA + b * scaleB;
#endif
}
