// (c) MX^Add
#pragma once

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"
#include "RendererTypes/Vector.h"

class FCurveFixed // Keys are Scalar
{
public:
	Scalar  Value;

	FCurveFixed();
	Scalar Eval(const uint8 *Base, uint16 Frame) const;

protected:
	uint16 Keys;

	struct FKeys
	{
		uint16     f;
		uint16 __alg; // Alignment!
		Scalar	   v;
	};

	static Scalar Eval(const FKeys *KBuff, uint16 Num, uint16 Frame);

	friend class FSceneExporter;
	friend class FExporterGizmo;
	friend class FSoftwareRasterizer;
};

class FCurveQuat // Keys are FVector4D quaternion
{
public:
	FVector4D Value;

	FCurveQuat();
	FVector4D Eval(const uint8 *Base, uint16 Frame) const;

protected:
	uint16 Keys;

	struct FKeys
	{
		uint16     f;
		uint16 __alg; // Alignment!
		FVector4D  v;
	};

	static FVector4D Eval(const FKeys *KBuff, uint16 Num, uint16 Frame);

	friend class FSceneExporter;
	friend class FExporterGizmo;
	friend class FSoftwareRasterizer;
};

static_assert(sizeof(FCurveFixed) == 8, "FCurveFixed must be 8 bytes !");
static_assert(sizeof(FCurveQuat) == 20, "FCurveQuat must be 20 bytes !");
