// (c) MX^Add

#include "RendererTypes/Gizmo.h"

FGizmo::FGizmo()
{
	ID	   = 0;
	Type   = ENodeType::Gizmo;
	Childs = 0;
	return;
}

FMatrix FGizmo::GetLocalTransform(const uint8 *Base, uint16 Frame) const
{
	FMatrix   r   = Transform.Rotation.Eval(Base, Frame).FromQuaterion();
	FVector3D Scl = FVector3D(Transform.Scale[0].Eval(Base, Frame), Transform.Scale[1].Eval(Base, Frame), Transform.Scale[2].Eval(Base, Frame));

	if (Scl.x != FixedOne || Scl.y != FixedOne || Scl.z != FixedOne)
	{
		FMatrix s; s.Identity();

	    s.m[0][0] = Scl.x;
	    s.m[1][1] = Scl.y;
		s.m[2][2] = Scl.z;

		r = s * r;
	}

	r.m[3][0] = Transform.Position[0].Eval(Base, Frame);
	r.m[3][1] = Transform.Position[1].Eval(Base, Frame);
	r.m[3][2] = Transform.Position[2].Eval(Base, Frame);

	return r;
}
