// (c) MX^Add
#pragma once

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"
#include "RendererTypes/Transform.h"

class FGizmo
{
public:
	enum class ENodeType : uint8
	{
		Gizmo,
		Camera,
		Mesh,
	};

protected:
	uint16	   ID;			// Node ID
	ENodeType  Type;        // Node type
	uint16	   Childs;      // Offset from base to childs list
	FTransform Transform;

	friend class FSceneExporter;
	friend class FExporterGizmo;
	friend class FScene;
	friend class FSoftwareRasterizer;
	
public:

	FGizmo();

	FMatrix GetLocalTransform(const uint8 *Base, uint16 Frame) const;

	inline uint16 GetID() const
	{
		return ID;
	}
};

static_assert(sizeof(FGizmo) == 76, "FGizmo must be 76 bytes !");
