// (c) MX^Add
#pragma once

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"
#include "RendererTypes/Vector.h"

class FMatrix
{
public:
	Scalar m[4][4];

	FMatrix() {}

	FMatrix(Scalar xx, Scalar xy, Scalar xz, Scalar xw,
			Scalar yx, Scalar yy, Scalar yz, Scalar yw,
			Scalar zx, Scalar zy, Scalar zz, Scalar zw,
			Scalar wx, Scalar wy, Scalar wz, Scalar ww)
	{ 
		m[0][0] = xx; m[0][1] = xy; m[0][2] = xz; m[0][3] = xw;
        m[1][0] = yx; m[1][1] = yy; m[1][2] = yz; m[1][3] = yw;
        m[2][0] = zx; m[2][1] = zy; m[2][2] = zz; m[2][3] = zw;
        m[3][0] = wx; m[3][1] = wy; m[3][2] = wz; m[3][3] = ww;

		return;	
	}

	inline void Identity()
	{
		m[0][0] = 1; m[0][1] = 0; m[0][2] = 0; m[0][3] = 0;
        m[1][0] = 0; m[1][1] = 1; m[1][2] = 0; m[1][3] = 0;
        m[2][0] = 0; m[2][1] = 0; m[2][2] = 1; m[2][3] = 0;
        m[3][0] = 0; m[3][1] = 0; m[3][2] = 0; m[3][3] = 1;

		return;
	}

	static FMatrix Multiply(const FMatrix& M1, const FMatrix& M2);

    static FMatrix MakeLookAt(const FVector3D &EyePosition, const FVector3D &FocusPosition, const FVector3D &UpDirection);

    static FMatrix MakePerspectiveProjection(uint8 FOV, uint16 Near, uint16 Far, Scalar Aspect);

	FMatrix &operator *= (const FMatrix &rhs)
	{
		*this = Multiply(*this, rhs);
		return *this;
	}

	FMatrix operator * (const FMatrix &rhs) const
	{
		return Multiply(*this, rhs);
	}

    FVector3D TransformNormal(const FVector3D &Nrm) const;

	FVector3D TransformPosition(const FVector3D &Pos) const;

	FVector4D TransformPositionFull(const FVector3D &Pos) const;

	FVector4D TransformPosition(const FVector4D &Pos) const;

	Scalar GetScaleX() const;

	Scalar GetScaleY() const;

	Scalar GetScaleZ() const;

	inline const FVector4D &Row(uint8 r) const
	{
		return *((FVector4D *)&m[r][0]);
	}

	inline FVector4D &Row(uint8 r)
	{
		return *((FVector4D *)&m[r][0]);
	}

	inline FVector4D Col(uint8 r) const
	{
		return FVector4D(m[0][r], m[1][r], m[2][r], m[3][r]);
	}
};

static_assert(sizeof(FMatrix) == 64, "FMatrix must be 64 bytes !");
