// (c) MX^Add
#pragma once

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"
#include "RendererTypes/Vector.h"
#include "RendererTypes/Gizmo.h"

class FMesh : public FGizmo
{
public:
	struct FVertex
	{
		FVector3D Pos;
		uint32    Nrm; // in XRGB_1_10_10_10 format (biased)
	};

	struct FVertexColor
	{
		FVector3D Pos;
		uint32    Nrm; // in XRGB_1_10_10_10 format (biased)
		uint16    Clr; // RGB565 color
	};

	struct FVertexUV
	{
		FVector3D Pos;
		uint32    Nrm; // in XRGB_1_10_10_10 format (biased)
		uint16    UV;  // UV encoded as multiply of 64
	};

	enum class EVertexFormat : uint8
	{
		Simple, 
		Color,
		UV,
	};

	FMesh();

	static FVector3D DecodeNormal(uint32 Nrm)
	{
		FVector3D r;

		r.x = Scalar(sint32( Nrm        & 0x3FF)-512) * FixedNrmFactor;
		r.y = Scalar(sint32((Nrm >> 10) & 0x3FF)-512) * FixedNrmFactor;
		r.z = Scalar(sint32((Nrm >> 20) & 0x3FF)-512) * FixedNrmFactor;

		return r;
	}

protected:

	EVertexFormat VertexFormat;
	uint8		  MaterialID;
	uint16        MaterialColor;

	uint16		  NumVetices;	
	uint16		  VerticesOffset;
	uint16		  NumFaces;
	uint16		  FacesOffset;

	FVector4D     BoundingSphere;

	friend class FSceneExporter;
	friend class FExporterMesh;
	friend class FSoftwareRasterizer;
	friend class FVisibilityChecker;
	friend class FVisibilityMeshInfo;
};

static_assert(sizeof(FMesh) == 104, "FMesh must be 104 bytes !");
