// (c) MX^Add
#pragma once

#include "BaseTypes/BaseTypes.h"
#include "BaseTypes/ScalarType.h"
#include "RendererTypes/Gizmo.h"
#include "RendererTypes/Camera.h"
#include "RendererTypes/Mesh.h"

/*
 * Scene is a blob of static memory followed by actual data
 *
 * [FScene] (with offsets to data, aligned to 4)
 * [Data]
 * 
 */

class FScene
{
public:
	static constexpr uint32 SceneMagicValue = 0x5CE4EB01;

protected:
	uint32 SceneMagic;
	uint16 NumFrames;
	uint16 SceneRootOffset;

	friend class FSceneExporter;
	friend class FSoftwareRasterizer;

public:
	FScene();

	inline const FGizmo *GetRoot() const
	{
		const uint8 *Base = ((uint8 *)this) + sizeof(FScene);
		return (const FGizmo *)(Base + (uint32(SceneRootOffset)<<3));
	}

	const uint16 GetNumFrames() const
	{
		return NumFrames;
	}
};

static_assert(sizeof(FScene) == 8, "FScene must be 8 bytes !");