// (c) MX^Add

#include "RendererTypes/Vector.h"
#include "RendererTypes/Matrix.h"

bool FVector4D::SphereInFrustum(const FMatrix& Local, const FVector4D* Planes) const
{
	FVector3D Center = Local.TransformPosition(FVector3D(x, y, z));
	Scalar     Radius = MAX(Local.GetScaleX(), Local.GetScaleY(), Local.GetScaleZ()) * w;

    for (uint8 i = 0; i < 6; i++)
    {
        if (Planes[i].Dot(Center) < -Radius)
            return false; // Outside
    }

	return true; // Inside or intersects
}

bool FVector4D::SphereInFrustum(const FVector3D &Center, Scalar Radius, const FVector4D* Planes)
{
    for (uint8 i = 0; i < 6; i++)
    {
        if (Planes[i].Dot(Center) < -Radius)
            return false; // Outside
    }

	return true; // Inside or intersects
}

void FVector4D::Slerp(const FVector4D &a, const FVector4D &_b, Scalar t)
{
    FVector4D b        = _b;
    Scalar     cosTheta = a.Dot(b);

    if (cosTheta < 0)
    {
        b        = -b;
        cosTheta = -cosTheta;
    }

    if (cosTheta > FixedSlerpEpsilon)
    {
        Lerp(a, b, t);
        Normalize();
        return;
    }

    Scalar theta    = FScalar::ACos(cosTheta);
    Scalar sinTheta = FScalar::Sin(theta);
    Scalar scaleA   = FScalar::Sin((FixedOne - t) * theta) / sinTheta;
    Scalar scaleB   = FScalar::Sin(t * theta) / sinTheta;

    *this = a * scaleA + b * scaleB;
    return;
}

FMatrix FVector4D::FromQuaterion() const
{
    FMatrix M; M.Identity();

    Scalar qxx = x * x;
    Scalar qyy = y * y;
    Scalar qzz = z * z;

    M.m[0][0] = Scalar(1) - Scalar(2) * qyy - Scalar(2) * qzz;
    M.m[0][1] = Scalar(2) * x * y + Scalar(2) * z * w;
    M.m[0][2] = Scalar(2) * x * z - Scalar(2) * y * w;

    M.m[1][0] = Scalar(2) * x * y - Scalar(2) * z * w;
    M.m[1][1] = Scalar(1) - Scalar(2) * qxx - Scalar(2) * qzz;
    M.m[1][2] = Scalar(2) * y * z + Scalar(2) * x * w;

    M.m[2][0] = Scalar(2) * x * z + Scalar(2) * y * w;
    M.m[2][1] = Scalar(2) * y * z - Scalar(2) * x * w;
    M.m[2][2] = Scalar(1) - Scalar(2) * qxx - Scalar(2) * qyy;

    return M;
}
