// VGA Video output
// Modified implementation, based on pico SDK

#ifndef SCANVIDEO_COMPOSABLE_SCANLINE_H_
#define SCANVIDEO_COMPOSABLE_SCANLINE_H_

#include "pico/types.h"
#include "scanvideo.pio.h"

#define video_24mhz_composable_prefix video_24mhz_composable_default

#define __EXTRA_CONCAT(x, y) __CONCAT(x,y)
#define video_24mhz_composable_program_extern(x) __EXTRA_CONCAT( __EXTRA_CONCAT(video_24mhz_composable_prefix, _offset_), x)
#define __DVP_JMP(x) ((unsigned)video_24mhz_composable_program_extern(x))
#define COMPOSABLE_COLOR_RUN __DVP_JMP(color_run)
#define COMPOSABLE_EOL_ALIGN __DVP_JMP(end_of_scanline_ALIGN)
#define COMPOSABLE_EOL_SKIP_ALIGN __DVP_JMP(end_of_scanline_skip_ALIGN)
#define COMPOSABLE_RAW_RUN __DVP_JMP(raw_run)
#define COMPOSABLE_RAW_1P __DVP_JMP(raw_1p)
#define COMPOSABLE_RAW_2P __DVP_JMP(raw_2p)
#define COMPOSABLE_RAW_1P_SKIP_ALIGN __DVP_JMP(raw_1p_skip_ALIGN)
#endif
