// VGA Video output
// Modified implementation, based on pico SDK

#if PICO_DO_VGA

#include "scanvideo.h"

const scanvideo_timing_t vga_timing_640x480_60_default =
        {
                .clock_freq      = 25000000, // Hz

                .h_active        = 640,
                .v_active        = 480,

                .h_front_porch   = 16,
                .h_pulse         = 64,
                .h_total         = 800,
                .h_sync_polarity = 1,

                .v_front_porch   = 1,
                .v_pulse         = 2,
                .v_total         = 523,
                .v_sync_polarity = 1,

                .enable_clock    = 0,
                .clock_polarity  = 0,

                .enable_den      = 0
        };

const scanvideo_mode_t vga_mode_320x240_60 =
        {
                .default_timing = &vga_timing_640x480_60_default,
                .pio_program    = &video_24mhz_composable,

                .width  = 320,
                .height = 240,
                .xscale = 2,
                .yscale = 2,
        };

#endif // PICO_DO_VGA